/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.aws2.sns.SnsResponse;
import org.apache.beam.sdk.io.aws2.sns.SnsResponseCoder;
import org.junit.Assert;
import org.junit.Test;

public class SnsResponseCoderTest {
    @Test
    public void verifyResponseWithStatusCodeAndText() throws IOException {
        SnsResponse expected = SnsResponse.create((Object)"test-1", (OptionalInt)OptionalInt.of(200), Optional.of("OK"));
        SnsResponseCoder coder = SnsResponseCoder.of((Coder)StringUtf8Coder.of());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        SnsResponse actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void verifyResponseWithStatusAndNoText() throws IOException {
        SnsResponse expected = SnsResponse.create((Object)"test-2", (OptionalInt)OptionalInt.of(200), Optional.empty());
        SnsResponseCoder coder = SnsResponseCoder.of((Coder)StringUtf8Coder.of());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        SnsResponse actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void verifyResponseWithNoStatusCodeAndText() throws IOException {
        SnsResponse expected = SnsResponse.create((Object)"test-3", (OptionalInt)OptionalInt.empty(), Optional.empty());
        SnsResponseCoder coder = SnsResponseCoder.of((Coder)StringUtf8Coder.of());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        SnsResponse actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

