/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.beam.sdk.io.aws2.sns.MockSnsAsyncBaseClient;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

final class MockSnsAsyncClient
extends MockSnsAsyncBaseClient {
    private final int statusCode;

    private MockSnsAsyncClient(int statusCode) {
        this.statusCode = statusCode;
    }

    static MockSnsAsyncClient withStatusCode(int statusCode) {
        return new MockSnsAsyncClient(statusCode);
    }

    public CompletableFuture<PublishResponse> publish(PublishRequest publishRequest) {
        SdkHttpFullResponse sdkHttpResponse = SdkHttpResponse.builder().statusCode(this.statusCode).build();
        PublishResponse.Builder builder = PublishResponse.builder();
        builder.messageId(UUID.randomUUID().toString());
        builder.sdkHttpResponse((SdkHttpResponse)sdkHttpResponse).build();
        PublishResponse response = (PublishResponse)builder.build();
        return CompletableFuture.completedFuture(response);
    }
}

