/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.sdk.io.aws2.s3.S3TestUtils;
import org.apache.beam.sdk.io.aws2.s3.S3WritableByteChannel;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

@RunWith(value=JUnit4.class)
public class S3WritableByteChannelTest {
    @Test
    public void write() throws IOException {
        this.writeFromOptions(S3TestUtils.s3Options());
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSEAlgorithm());
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSECustomerKey());
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSEKMSKeyId());
        Assert.assertThrows(IllegalArgumentException.class, () -> this.writeFromOptions(S3TestUtils.s3OptionsWithMultipleSSEOptions()));
    }

    private void writeFromOptions(S3Options options) throws IOException {
        S3Client mockS3Client = (S3Client)Mockito.mock(S3Client.class, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.RETURNS_SMART_NULLS));
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://bucket/dir/file");
        CreateMultipartUploadResponse.Builder builder = CreateMultipartUploadResponse.builder().uploadId("upload-id");
        ServerSideEncryption sseAlgorithm = ServerSideEncryption.fromValue((String)options.getSSEAlgorithm());
        if (options.getSSEAlgorithm() != null) {
            builder.serverSideEncryption(sseAlgorithm);
        }
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            builder.sseCustomerKeyMD5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        if (options.getSSEKMSKeyId() != null) {
            sseAlgorithm = ServerSideEncryption.AWS_KMS;
            builder.serverSideEncryption(sseAlgorithm);
        }
        CreateMultipartUploadResponse createMultipartUploadResponse = (CreateMultipartUploadResponse)builder.build();
        ((S3Client)Mockito.doReturn((Object)createMultipartUploadResponse).when((Object)mockS3Client)).createMultipartUpload((CreateMultipartUploadRequest)ArgumentMatchers.any(CreateMultipartUploadRequest.class));
        CreateMultipartUploadRequest createMultipartUploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(path.getBucket()).key(path.getKey()).build();
        CreateMultipartUploadResponse mockCreateMultipartUploadResponse1 = mockS3Client.createMultipartUpload(createMultipartUploadRequest);
        Assert.assertEquals((Object)sseAlgorithm, (Object)mockCreateMultipartUploadResponse1.serverSideEncryption());
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)mockCreateMultipartUploadResponse1.sseCustomerKeyMD5());
        UploadPartResponse.Builder uploadPartResponseBuilder = UploadPartResponse.builder().eTag("etag");
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            uploadPartResponseBuilder.sseCustomerKeyMD5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        UploadPartResponse response = (UploadPartResponse)uploadPartResponseBuilder.build();
        ((S3Client)Mockito.doReturn((Object)response).when((Object)mockS3Client)).uploadPart((UploadPartRequest)ArgumentMatchers.any(UploadPartRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class));
        UploadPartResponse mockUploadPartResult = mockS3Client.uploadPart((UploadPartRequest)UploadPartRequest.builder().build(), RequestBody.empty());
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)mockUploadPartResult.sseCustomerKeyMD5());
        S3WritableByteChannel channel = new S3WritableByteChannel(mockS3Client, path, "text/plain", options);
        int contentSize = 0x2080000;
        ByteBuffer uploadContent = ByteBuffer.allocate((int)((double)contentSize * 2.5));
        for (int i = 0; i < contentSize; ++i) {
            uploadContent.put((byte)-1);
        }
        uploadContent.flip();
        int uploadedSize = channel.write(uploadContent);
        Assert.assertEquals((long)contentSize, (long)uploadedSize);
        CompleteMultipartUploadResponse completeMultipartUploadResponse = (CompleteMultipartUploadResponse)CompleteMultipartUploadResponse.builder().build();
        ((S3Client)Mockito.doReturn((Object)completeMultipartUploadResponse).when((Object)mockS3Client)).completeMultipartUpload((CompleteMultipartUploadRequest)ArgumentMatchers.any(CompleteMultipartUploadRequest.class));
        channel.close();
        int partQuantity = (int)Math.ceil((double)contentSize / (double)options.getS3UploadBufferSizeBytes().intValue()) + 1;
        ((S3Client)Mockito.verify((Object)mockS3Client, (VerificationMode)Mockito.times((int)2))).createMultipartUpload((CreateMultipartUploadRequest)ArgumentMatchers.isNotNull());
        ((S3Client)Mockito.verify((Object)mockS3Client, (VerificationMode)Mockito.times((int)partQuantity))).uploadPart((UploadPartRequest)ArgumentMatchers.isNotNull(), (RequestBody)ArgumentMatchers.any(RequestBody.class));
        ((S3Client)Mockito.verify((Object)mockS3Client, (VerificationMode)Mockito.times((int)1))).completeMultipartUpload((CompleteMultipartUploadRequest)ArgumentMatchers.notNull());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockS3Client});
    }

    @Test
    public void testAtMostOne() {
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true, true}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true, false}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false, false}));
    }
}

