/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.DefaultS3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystem;
import org.apache.beam.sdk.io.aws2.s3.SSECustomerKey;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.mockito.Mockito;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

class S3TestUtils {
    S3TestUtils() {
    }

    static S3Options s3Options() {
        S3Options options = (S3Options)PipelineOptionsFactory.as(S3Options.class);
        options.setAwsRegion("us-west-1");
        options.setS3UploadBufferSizeBytes(Integer.valueOf(0x500000));
        return options;
    }

    static S3Options s3OptionsWithPathStyleAccessEnabled() {
        S3Options options = (S3Options)PipelineOptionsFactory.as(S3Options.class);
        options.setAwsRegion("us-west-1");
        options.setS3UploadBufferSizeBytes(Integer.valueOf(0x500000));
        options.setS3ClientFactoryClass(PathStyleAccessS3ClientBuilderFactory.class);
        return options;
    }

    static S3Options s3OptionsWithSSEAlgorithm() {
        S3Options options = S3TestUtils.s3Options();
        options.setSSEAlgorithm(ServerSideEncryption.AES256.name());
        return options;
    }

    static S3Options s3OptionsWithSSECustomerKey() {
        S3Options options = S3TestUtils.s3Options();
        options.setSSECustomerKey(SSECustomerKey.builder().key("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=").algorithm("AES256").build());
        return options;
    }

    static S3Options s3OptionsWithSSEKMSKeyId() {
        S3Options options = S3TestUtils.s3Options();
        String ssekmsKeyId = "arn:aws:kms:eu-west-1:123456789012:key/dc123456-7890-ABCD-EF01-234567890ABC";
        options.setSSEKMSKeyId(ssekmsKeyId);
        options.setSSEAlgorithm("aws:kms");
        return options;
    }

    static S3Options s3OptionsWithMultipleSSEOptions() {
        S3Options options = S3TestUtils.s3OptionsWithSSEKMSKeyId();
        options.setSSECustomerKey(SSECustomerKey.builder().key("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=").algorithm("AES256").build());
        return options;
    }

    static S3FileSystem buildMockedS3FileSystem(S3Options options) {
        return S3TestUtils.buildMockedS3FileSystem(options, (S3Client)Mockito.mock(S3Client.class));
    }

    static S3FileSystem buildMockedS3FileSystem(S3Options options, S3Client client) {
        S3FileSystem s3FileSystem = new S3FileSystem(options);
        s3FileSystem.setS3Client(client);
        return s3FileSystem;
    }

    static @Nullable String getSSECustomerKeyMd5(S3Options options) {
        String sseCostumerKey = options.getSSECustomerKey().getKey();
        if (sseCostumerKey != null) {
            Base64.Decoder decoder = Base64.getDecoder();
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(DigestUtils.md5((byte[])decoder.decode(sseCostumerKey.getBytes(StandardCharsets.UTF_8))));
        }
        return null;
    }

    private static class PathStyleAccessS3ClientBuilderFactory
    extends DefaultS3ClientBuilderFactory {
        private PathStyleAccessS3ClientBuilderFactory() {
        }

        public S3ClientBuilder createBuilder(S3Options s3Options) {
            S3ClientBuilder s3ClientBuilder = super.createBuilder(s3Options);
            return (S3ClientBuilder)s3ClientBuilder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
        }
    }
}

