/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import akka.http.scaladsl.Http;
import io.findify.s3mock.S3Mock;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.MatchResultMatcher;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystem;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.sdk.io.aws2.s3.S3TestUtils;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CopyPartResult;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyResponse;

@RunWith(value=JUnit4.class)
public class S3FileSystemTest {
    private static S3Mock api;
    private static S3Client client;

    @BeforeClass
    public static void beforeClass() {
        api = new S3Mock.Builder().withInMemoryBackend().withPort(8002).build();
        Http.ServerBinding binding = api.start();
        URI endpoint = URI.create("http://localhost:" + binding.localAddress().getPort());
        S3Configuration s3Configuration = (S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build();
        client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.US_WEST_1)).serviceConfiguration(s3Configuration)).endpointOverride(endpoint)).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).build();
    }

    @AfterClass
    public static void afterClass() {
        api.stop();
    }

    @Test
    public void testGetScheme() {
        S3FileSystem s3FileSystem = new S3FileSystem(S3TestUtils.s3Options());
        Assert.assertEquals((Object)"s3", (Object)s3FileSystem.getScheme());
    }

    @Test
    public void testGetPathStyleAccessEnabled() throws URISyntaxException {
        S3FileSystem s3FileSystem = new S3FileSystem(S3TestUtils.s3OptionsWithPathStyleAccessEnabled());
        URL s3Url = s3FileSystem.getS3Client().utilities().getUrl((GetUrlRequest)GetUrlRequest.builder().bucket("bucket").key("file").build());
        Assert.assertEquals((Object)"https://s3.us-west-1.amazonaws.com/bucket/file", (Object)s3Url.toURI().toString());
    }

    @Test
    public void testCopy() throws IOException {
        this.testCopy(S3TestUtils.s3Options());
        this.testCopy(S3TestUtils.s3OptionsWithSSECustomerKey());
    }

    private HeadObjectRequest createObjectHeadRequest(S3ResourceId path, S3Options options) {
        return (HeadObjectRequest)HeadObjectRequest.builder().bucket(path.getBucket()).key(path.getKey()).sseCustomerKey(options.getSSECustomerKey().getKey()).sseCustomerAlgorithm(options.getSSECustomerKey().getAlgorithm()).build();
    }

    private void assertGetObjectHead(S3FileSystem s3FileSystem, HeadObjectRequest request, S3Options options, HeadObjectResponse objectMetadata) {
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher(request)))).thenReturn((Object)objectMetadata);
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)s3FileSystem.getS3Client().headObject(request).sseCustomerKeyMD5());
    }

    private void testCopy(S3Options options) throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId sourcePath = S3ResourceId.fromUri((String)"s3://bucket/from");
        S3ResourceId destinationPath = S3ResourceId.fromUri((String)"s3://bucket/to");
        HeadObjectResponse.Builder builder = HeadObjectResponse.builder().contentLength(Long.valueOf(0L));
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            builder.sseCustomerKeyMD5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)builder.build();
        this.assertGetObjectHead(s3FileSystem, this.createObjectHeadRequest(sourcePath, options), options, headObjectResponse);
        s3FileSystem.copy(sourcePath, destinationPath);
        ((S3Client)Mockito.verify((Object)s3FileSystem.getS3Client(), (VerificationMode)Mockito.times((int)1))).copyObject((CopyObjectRequest)ArgumentMatchers.any(CopyObjectRequest.class));
        HeadObjectResponse bigHeadObjectResponse = (HeadObjectResponse)headObjectResponse.toBuilder().contentLength(Long.valueOf(0x140000000L)).build();
        this.assertGetObjectHead(s3FileSystem, this.createObjectHeadRequest(sourcePath, options), options, headObjectResponse);
        try {
            s3FileSystem.copy(sourcePath, destinationPath);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ((S3Client)Mockito.verify((Object)s3FileSystem.getS3Client(), (VerificationMode)Mockito.never())).copyObject((CopyObjectRequest)null);
    }

    @Test
    public void testAtomicCopy() {
        this.testAtomicCopy(S3TestUtils.s3Options());
        this.testAtomicCopy(S3TestUtils.s3OptionsWithSSECustomerKey());
    }

    private void testAtomicCopy(S3Options options) {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(options);
        S3ResourceId sourcePath = S3ResourceId.fromUri((String)"s3://bucket/from");
        S3ResourceId destinationPath = S3ResourceId.fromUri((String)"s3://bucket/to");
        CopyObjectResponse.Builder builder = CopyObjectResponse.builder();
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            builder.sseCustomerKeyMD5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        CopyObjectResponse copyObjectResponse = (CopyObjectResponse)builder.build();
        CopyObjectRequest copyObjectRequest = (CopyObjectRequest)CopyObjectRequest.builder().copySource(sourcePath.getBucket() + "/" + sourcePath.getKey()).destinationBucket(destinationPath.getBucket()).destinationBucket(destinationPath.getKey()).sseCustomerKey(options.getSSECustomerKey().getKey()).copySourceSSECustomerAlgorithm(options.getSSECustomerKey().getAlgorithm()).build();
        Mockito.when((Object)s3FileSystem.getS3Client().copyObject((CopyObjectRequest)ArgumentMatchers.any(CopyObjectRequest.class))).thenReturn((Object)copyObjectResponse);
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)s3FileSystem.getS3Client().copyObject(copyObjectRequest).sseCustomerKeyMD5());
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)HeadObjectResponse.builder().build();
        s3FileSystem.atomicCopy(sourcePath, destinationPath, headObjectResponse);
        ((S3Client)Mockito.verify((Object)s3FileSystem.getS3Client(), (VerificationMode)Mockito.times((int)2))).copyObject((CopyObjectRequest)ArgumentMatchers.any(CopyObjectRequest.class));
    }

    @Test
    public void testMultipartCopy() {
        this.testMultipartCopy(S3TestUtils.s3Options());
        this.testMultipartCopy(S3TestUtils.s3OptionsWithSSECustomerKey());
    }

    private void testMultipartCopy(S3Options options) {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(options);
        S3ResourceId sourcePath = S3ResourceId.fromUri((String)"s3://bucket/from");
        S3ResourceId destinationPath = S3ResourceId.fromUri((String)"s3://bucket/to");
        CreateMultipartUploadResponse.Builder builder = CreateMultipartUploadResponse.builder().uploadId("upload-id");
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            builder.sseCustomerKeyMD5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        CreateMultipartUploadResponse createMultipartUploadResponse = (CreateMultipartUploadResponse)builder.build();
        Mockito.when((Object)s3FileSystem.getS3Client().createMultipartUpload((CreateMultipartUploadRequest)ArgumentMatchers.any(CreateMultipartUploadRequest.class))).thenReturn((Object)createMultipartUploadResponse);
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)s3FileSystem.getS3Client().createMultipartUpload((CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(destinationPath.getBucket()).key(destinationPath.getKey()).build()).sseCustomerKeyMD5());
        HeadObjectResponse.Builder headObjectResponseBuilder = HeadObjectResponse.builder().contentLength(Long.valueOf((long)((double)options.getS3UploadBufferSizeBytes().intValue() * 1.5))).contentEncoding("read-seek-efficient");
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            headObjectResponseBuilder.sseCustomerKeyMD5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)headObjectResponseBuilder.build();
        this.assertGetObjectHead(s3FileSystem, this.createObjectHeadRequest(sourcePath, options), options, headObjectResponse);
        CopyPartResult copyPartResult1 = (CopyPartResult)CopyPartResult.builder().eTag("etag-1").build();
        CopyPartResult copyPartResult2 = (CopyPartResult)CopyPartResult.builder().eTag("etag-2").build();
        UploadPartCopyResponse.Builder uploadPartCopyResponseBuilder1 = UploadPartCopyResponse.builder().copyPartResult(copyPartResult1);
        UploadPartCopyResponse.Builder uploadPartCopyResponseBuilder2 = UploadPartCopyResponse.builder().copyPartResult(copyPartResult2);
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            uploadPartCopyResponseBuilder1.sseCustomerKeyMD5(S3TestUtils.getSSECustomerKeyMd5(options));
            uploadPartCopyResponseBuilder2.sseCustomerKeyMD5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        UploadPartCopyResponse uploadPartCopyResponse1 = (UploadPartCopyResponse)uploadPartCopyResponseBuilder1.build();
        UploadPartCopyResponse uploadPartCopyResponse2 = (UploadPartCopyResponse)uploadPartCopyResponseBuilder2.build();
        UploadPartCopyRequest uploadPartCopyRequest = (UploadPartCopyRequest)UploadPartCopyRequest.builder().sseCustomerKey(options.getSSECustomerKey().getKey()).build();
        Mockito.when((Object)s3FileSystem.getS3Client().uploadPartCopy((UploadPartCopyRequest)ArgumentMatchers.any(UploadPartCopyRequest.class))).thenReturn((Object)uploadPartCopyResponse1).thenReturn((Object)uploadPartCopyResponse2);
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)s3FileSystem.getS3Client().uploadPartCopy(uploadPartCopyRequest).sseCustomerKeyMD5());
        s3FileSystem.multipartCopy(sourcePath, destinationPath, headObjectResponse);
        ((S3Client)Mockito.verify((Object)s3FileSystem.getS3Client(), (VerificationMode)Mockito.times((int)1))).completeMultipartUpload((CompleteMultipartUploadRequest)ArgumentMatchers.any(CompleteMultipartUploadRequest.class));
    }

    @Test
    public void deleteThousandsOfObjectsInMultipleBuckets() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        ImmutableList buckets = ImmutableList.of((Object)"bucket1", (Object)"bucket2");
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < 2500; ++i) {
            keys.add(String.format("key-%d", i));
        }
        ArrayList<S3ResourceId> paths = new ArrayList<S3ResourceId>();
        for (String bucket : buckets) {
            for (String key : keys) {
                paths.add(S3ResourceId.fromComponents((String)bucket, (String)key));
            }
        }
        s3FileSystem.delete(paths);
        ((S3Client)Mockito.verify((Object)s3FileSystem.getS3Client(), (VerificationMode)Mockito.times((int)6))).deleteObjects((DeleteObjectsRequest)ArgumentMatchers.any(DeleteObjectsRequest.class));
    }

    @Test
    public void matchNonGlob() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/filethatexists");
        long lastModifiedMillis = 1540000000000L;
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)HeadObjectResponse.builder().contentLength(Long.valueOf(100L)).contentEncoding("read-seek-efficient").lastModified(Instant.ofEpochMilli(lastModifiedMillis)).build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher((HeadObjectRequest)HeadObjectRequest.builder().bucket(path.getBucket()).key(path.getKey()).build())))).thenReturn((Object)headObjectResponse);
        MatchResult result = s3FileSystem.matchNonGlobPath(path);
        MatcherAssert.assertThat((Object)result, (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setSizeBytes(100L).setLastModifiedMillis(lastModifiedMillis).setResourceId((ResourceId)path).setIsReadSeekEfficient(true).build())));
    }

    @Test
    public void matchNonGlobNotReadSeekEfficient() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/filethatexists");
        long lastModifiedMillis = 1540000000000L;
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)HeadObjectResponse.builder().contentLength(Long.valueOf(100L)).lastModified(Instant.ofEpochMilli(lastModifiedMillis)).contentEncoding("gzip").build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher((HeadObjectRequest)HeadObjectRequest.builder().bucket(path.getBucket()).key(path.getKey()).build())))).thenReturn((Object)headObjectResponse);
        MatchResult result = s3FileSystem.matchNonGlobPath(path);
        MatcherAssert.assertThat((Object)result, (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setSizeBytes(100L).setLastModifiedMillis(lastModifiedMillis).setResourceId((ResourceId)path).setIsReadSeekEfficient(false).build())));
    }

    @Test
    public void matchNonGlobNullContentEncoding() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/filethatexists");
        long lastModifiedMillis = 1540000000000L;
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)HeadObjectResponse.builder().contentLength(Long.valueOf(100L)).lastModified(Instant.ofEpochMilli(lastModifiedMillis)).contentEncoding(null).build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher((HeadObjectRequest)HeadObjectRequest.builder().bucket(path.getBucket()).key(path.getKey()).build())))).thenReturn((Object)headObjectResponse);
        MatchResult result = s3FileSystem.matchNonGlobPath(path);
        MatcherAssert.assertThat((Object)result, (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setSizeBytes(100L).setLastModifiedMillis(lastModifiedMillis).setResourceId((ResourceId)path).setIsReadSeekEfficient(true).build())));
    }

    @Test
    public void matchNonGlobNotFound() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/nonexistentfile");
        AwsServiceException exception = S3Exception.builder().message("mock exception").statusCode(404).build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher((HeadObjectRequest)HeadObjectRequest.builder().bucket(path.getBucket()).key(path.getKey()).build())))).thenThrow(new Throwable[]{exception});
        MatchResult result = s3FileSystem.matchNonGlobPath(path);
        MatcherAssert.assertThat((Object)result, (Matcher)MatchResultMatcher.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException()));
    }

    @Test
    public void matchNonGlobForbidden() {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        AwsServiceException exception = S3Exception.builder().message("mock exception").statusCode(403).build();
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/keyname");
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher((HeadObjectRequest)HeadObjectRequest.builder().bucket(path.getBucket()).key(path.getKey()).build())))).thenThrow(new Throwable[]{exception});
        MatcherAssert.assertThat((Object)s3FileSystem.matchNonGlobPath(path), (Matcher)MatchResultMatcher.create(MatchResult.Status.ERROR, new IOException((Throwable)exception)));
    }

    @Test
    public void matchGlob() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/foo/bar*baz");
        ListObjectsV2Request firstRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(path.getBucket()).prefix(path.getKeyNonWildcardPrefix()).continuationToken(null).build();
        S3Object firstMatch = (S3Object)S3Object.builder().key("foo/bar0baz").size(Long.valueOf(100L)).lastModified(Instant.ofEpochMilli(1540000000001L)).build();
        S3Object secondMatch = (S3Object)S3Object.builder().key("foo/bar1qux").size(Long.valueOf(200L)).lastModified(Instant.ofEpochMilli(1540000000002L)).build();
        ListObjectsV2Response firstResponse = (ListObjectsV2Response)ListObjectsV2Response.builder().nextContinuationToken("token").contents(new S3Object[]{firstMatch, secondMatch}).build();
        Mockito.when((Object)s3FileSystem.getS3Client().listObjectsV2((ListObjectsV2Request)ArgumentMatchers.argThat((ArgumentMatcher)new ListObjectsV2RequestArgumentMatches(firstRequest)))).thenReturn((Object)firstResponse);
        ListObjectsV2Request secondRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(path.getBucket()).prefix(path.getKeyNonWildcardPrefix()).continuationToken("token").build();
        S3Object thirdMatch = (S3Object)S3Object.builder().key("foo/bar2baz").size(Long.valueOf(300L)).lastModified(Instant.ofEpochMilli(1540000000003L)).build();
        ListObjectsV2Response secondResponse = (ListObjectsV2Response)ListObjectsV2Response.builder().nextContinuationToken(null).contents(new S3Object[]{thirdMatch}).build();
        Mockito.when((Object)s3FileSystem.getS3Client().listObjectsV2((ListObjectsV2Request)ArgumentMatchers.argThat((ArgumentMatcher)new ListObjectsV2RequestArgumentMatches(secondRequest)))).thenReturn((Object)secondResponse);
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)HeadObjectResponse.builder().contentEncoding("").build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.any(HeadObjectRequest.class))).thenReturn((Object)headObjectResponse);
        MatcherAssert.assertThat((Object)((MatchResult)s3FileSystem.matchGlobPaths((Collection)ImmutableList.of((Object)path)).get(0)), (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setIsReadSeekEfficient(true).setResourceId((ResourceId)S3ResourceId.fromComponents((String)path.getBucket(), (String)firstMatch.key())).setSizeBytes(firstMatch.size().longValue()).setLastModifiedMillis(firstMatch.lastModified().toEpochMilli()).build(), (Object)MatchResult.Metadata.builder().setIsReadSeekEfficient(true).setResourceId((ResourceId)S3ResourceId.fromComponents((String)path.getBucket(), (String)thirdMatch.key())).setSizeBytes(thirdMatch.size().longValue()).setLastModifiedMillis(thirdMatch.lastModified().toEpochMilli()).build())));
    }

    @Test
    public void matchGlobWithSlashes() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/foo/bar\\baz*");
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(path.getBucket()).prefix(path.getKeyNonWildcardPrefix()).continuationToken(null).build();
        S3Object firstMatch = (S3Object)S3Object.builder().key("foo/bar\\baz0").size(Long.valueOf(100L)).lastModified(Instant.ofEpochMilli(1540000000001L)).build();
        S3Object secondMatch = (S3Object)S3Object.builder().key("foo/bar/baz1").size(Long.valueOf(200L)).lastModified(Instant.ofEpochMilli(1540000000002L)).build();
        ListObjectsV2Response response = (ListObjectsV2Response)ListObjectsV2Response.builder().contents(new S3Object[]{firstMatch, secondMatch}).build();
        Mockito.when((Object)s3FileSystem.getS3Client().listObjectsV2((ListObjectsV2Request)ArgumentMatchers.argThat((ArgumentMatcher)new ListObjectsV2RequestArgumentMatches(request)))).thenReturn((Object)response);
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)HeadObjectResponse.builder().contentEncoding("").build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.any(HeadObjectRequest.class))).thenReturn((Object)headObjectResponse);
        MatcherAssert.assertThat((Object)((MatchResult)s3FileSystem.matchGlobPaths((Collection)ImmutableList.of((Object)path)).get(0)), (Matcher)MatchResultMatcher.create((List<MatchResult.Metadata>)ImmutableList.of((Object)MatchResult.Metadata.builder().setIsReadSeekEfficient(true).setResourceId((ResourceId)S3ResourceId.fromComponents((String)path.getBucket(), (String)firstMatch.key())).setSizeBytes(firstMatch.size().longValue()).setLastModifiedMillis(firstMatch.lastModified().toEpochMilli()).build())));
    }

    @Test
    public void matchVariousInvokeThreadPool() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options());
        AwsServiceException notFoundException = S3Exception.builder().message("mock exception").statusCode(404).build();
        S3ResourceId pathNotExist = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/nonexistentfile");
        HeadObjectRequest headObjectRequestNotExist = (HeadObjectRequest)HeadObjectRequest.builder().bucket(pathNotExist.getBucket()).key(pathNotExist.getKey()).build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher(headObjectRequestNotExist)))).thenThrow(new Throwable[]{notFoundException});
        SdkServiceException forbiddenException = SdkServiceException.builder().message("mock exception").statusCode(403).build();
        S3ResourceId pathForbidden = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/forbiddenfile");
        HeadObjectRequest headObjectRequestForbidden = (HeadObjectRequest)HeadObjectRequest.builder().bucket(pathForbidden.getBucket()).key(pathForbidden.getKey()).build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher(headObjectRequestForbidden)))).thenThrow(new Throwable[]{forbiddenException});
        S3ResourceId pathExist = S3ResourceId.fromUri((String)"s3://testbucket/testdirectory/filethatexists");
        HeadObjectRequest headObjectRequestExist = (HeadObjectRequest)HeadObjectRequest.builder().bucket(pathExist.getBucket()).key(pathExist.getKey()).build();
        HeadObjectResponse s3ObjectMetadata = (HeadObjectResponse)HeadObjectResponse.builder().contentLength(Long.valueOf(100L)).contentEncoding("not-gzip").lastModified(Instant.ofEpochMilli(1540000000000L)).build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher(headObjectRequestExist)))).thenReturn((Object)s3ObjectMetadata);
        S3ResourceId pathGlob = S3ResourceId.fromUri((String)"s3://testbucket/path/part*");
        S3Object foundListObject = (S3Object)S3Object.builder().key("path/part-0").size(Long.valueOf(200L)).lastModified(Instant.ofEpochMilli(1541000000000L)).build();
        ListObjectsV2Response listObjectsResponse = (ListObjectsV2Response)ListObjectsV2Response.builder().continuationToken(null).contents(new S3Object[]{foundListObject}).build();
        Mockito.when((Object)s3FileSystem.getS3Client().listObjectsV2((ListObjectsV2Request)ArgumentMatchers.notNull())).thenReturn((Object)listObjectsResponse);
        HeadObjectResponse headObjectResponse = (HeadObjectResponse)HeadObjectResponse.builder().contentEncoding("").build();
        Mockito.when((Object)s3FileSystem.getS3Client().headObject((HeadObjectRequest)ArgumentMatchers.argThat((ArgumentMatcher)new GetHeadObjectRequestMatcher((HeadObjectRequest)HeadObjectRequest.builder().bucket(pathGlob.getBucket()).key("path/part-0").build())))).thenReturn((Object)headObjectResponse);
        MatcherAssert.assertThat((Object)s3FileSystem.match((List)ImmutableList.of((Object)pathNotExist.toString(), (Object)pathForbidden.toString(), (Object)pathExist.toString(), (Object)pathGlob.toString())), (Matcher)Matchers.contains((Matcher[])new Matcher[]{MatchResultMatcher.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException()), MatchResultMatcher.create(MatchResult.Status.ERROR, new IOException((Throwable)forbiddenException)), MatchResultMatcher.create(100L, 1540000000000L, (ResourceId)pathExist, true), MatchResultMatcher.create(200L, 1541000000000L, (ResourceId)S3ResourceId.fromComponents((String)pathGlob.getBucket(), (String)foundListObject.key()), true)}));
    }

    @Test
    public void testWriteAndRead() throws IOException {
        S3FileSystem s3FileSystem = S3TestUtils.buildMockedS3FileSystem(S3TestUtils.s3Options(), client);
        client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket("testbucket").build());
        byte[] writtenArray = new byte[]{0};
        ByteBuffer bb = ByteBuffer.allocate(writtenArray.length);
        bb.put(writtenArray);
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://testbucket/foo/bar.txt");
        WritableByteChannel writableByteChannel = s3FileSystem.create(path, (CreateOptions)((CreateOptions.StandardCreateOptions.Builder)CreateOptions.StandardCreateOptions.builder().setMimeType("application/text")).build());
        writableByteChannel.write(bb);
        writableByteChannel.close();
        ByteBuffer bb2 = ByteBuffer.allocate(writtenArray.length);
        ReadableByteChannel open = s3FileSystem.open(path);
        open.read(bb2);
        byte[] readArray = bb2.array();
        Assert.assertArrayEquals((byte[])readArray, (byte[])writtenArray);
        open.close();
    }

    private static class GetHeadObjectRequestMatcher
    implements ArgumentMatcher<HeadObjectRequest> {
        private final HeadObjectRequest expected;

        GetHeadObjectRequestMatcher(HeadObjectRequest expected) {
            this.expected = expected;
        }

        public boolean matches(HeadObjectRequest obj) {
            if (obj == null) {
                return false;
            }
            return obj.bucket().equals(this.expected.bucket()) && obj.key().equals(this.expected.key());
        }
    }

    static class ListObjectsV2RequestArgumentMatches
    implements ArgumentMatcher<ListObjectsV2Request> {
        private final ListObjectsV2Request expected;

        ListObjectsV2RequestArgumentMatches(ListObjectsV2Request expected) {
            this.expected = (ListObjectsV2Request)Preconditions.checkNotNull((Object)expected);
        }

        public boolean matches(ListObjectsV2Request argument) {
            if (argument != null) {
                return this.expected.bucket().equals(argument.bucket()) && this.expected.prefix().equals(argument.prefix()) && (this.expected.continuationToken() == null ? argument.continuationToken() == null : this.expected.continuationToken().equals(argument.continuationToken()));
            }
            return false;
        }
    }
}

