/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import org.apache.beam.sdk.io.aws2.options.AwsSerializableUtils;
import org.junit.Assert;
import org.junit.Test;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;

public class AwsSerializableUtilsTest {
    private static final String ACCESS_KEY_ID = "ACCESS_KEY_ID";
    private static final String SECRET_ACCESS_KEY = "SECRET_ACCESS_KEY";

    @Test
    public void testAwsCredentialsProviderSerialization() {
        StaticCredentialsProvider awsCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)ACCESS_KEY_ID, (String)SECRET_ACCESS_KEY));
        String awsCredentialsProviderSerialized = AwsSerializableUtils.serializeAwsCredentialsProvider((AwsCredentialsProvider)awsCredentialsProvider);
        AwsCredentialsProvider awsCredentialsProviderDeserialized = AwsSerializableUtils.deserializeAwsCredentialsProvider((String)awsCredentialsProviderSerialized);
        Assert.assertTrue((boolean)(awsCredentialsProviderDeserialized instanceof StaticCredentialsProvider));
        AwsCredentials awsCredentials = awsCredentialsProviderDeserialized.resolveCredentials();
        Assert.assertEquals((Object)ACCESS_KEY_ID, (Object)awsCredentials.accessKeyId());
        Assert.assertEquals((Object)SECRET_ACCESS_KEY, (Object)awsCredentials.secretAccessKey());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailOnAwsCredentialsProviderSerialization() {
        UnknownAwsCredentialsProvider awsCredentialsProvider = new UnknownAwsCredentialsProvider();
        AwsSerializableUtils.serializeAwsCredentialsProvider((AwsCredentialsProvider)awsCredentialsProvider);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailOnAwsCredentialsProviderDeserialization() {
        AwsSerializableUtils.deserializeAwsCredentialsProvider((String)"invalid string");
    }

    static class UnknownAwsCredentialsProvider
    implements AwsCredentialsProvider {
        UnknownAwsCredentialsProvider() {
        }

        public AwsCredentials resolveCredentials() {
            return AwsBasicCredentials.create((String)AwsSerializableUtilsTest.ACCESS_KEY_ID, (String)AwsSerializableUtilsTest.SECRET_ACCESS_KEY);
        }
    }
}

