/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import org.apache.beam.sdk.io.aws2.options.AwsModule;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.utils.AttributeMap;

@RunWith(value=JUnit4.class)
public class AwsModuleTest {
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new AwsModule());

    @Test
    public void testObjectMapperIsAbleToFindModule() {
        List modules = ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader());
        MatcherAssert.assertThat((Object)modules, (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(AwsModule.class)));
    }

    @Test
    public void testStaticCredentialsProviderSerializationDeserialization() throws Exception {
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"key-id", (String)"secret-key"));
        String serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        AwsCredentialsProvider deserializedCredentialsProvider = (AwsCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AwsCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        Assert.assertEquals((Object)credentialsProvider.resolveCredentials().accessKeyId(), (Object)deserializedCredentialsProvider.resolveCredentials().accessKeyId());
        Assert.assertEquals((Object)credentialsProvider.resolveCredentials().secretAccessKey(), (Object)deserializedCredentialsProvider.resolveCredentials().secretAccessKey());
        AwsSessionCredentials sessionCredentials = AwsSessionCredentials.create((String)"key-id", (String)"secret-key", (String)"session-token");
        credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)sessionCredentials);
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AwsCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AwsCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        AwsSessionCredentials deserializedCredentials = (AwsSessionCredentials)deserializedCredentialsProvider.resolveCredentials();
        Assert.assertEquals((Object)sessionCredentials.accessKeyId(), (Object)deserializedCredentials.accessKeyId());
        Assert.assertEquals((Object)sessionCredentials.secretAccessKey(), (Object)deserializedCredentials.secretAccessKey());
        Assert.assertEquals((Object)sessionCredentials.sessionToken(), (Object)deserializedCredentials.sessionToken());
    }

    @Test
    public void testAwsCredentialsProviderSerializationDeserialization() throws Exception {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.create();
        String serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        AwsCredentialsProvider deserializedCredentialsProvider = (AwsCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, DefaultCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        credentialsProvider = EnvironmentVariableCredentialsProvider.create();
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AwsCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AwsCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        credentialsProvider = SystemPropertyCredentialsProvider.create();
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AwsCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AwsCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        credentialsProvider = ProfileCredentialsProvider.create();
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AwsCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AwsCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
        credentialsProvider = ContainerCredentialsProvider.builder().build();
        serializedCredentialsProvider = this.objectMapper.writeValueAsString((Object)credentialsProvider);
        deserializedCredentialsProvider = (AwsCredentialsProvider)this.objectMapper.readValue(serializedCredentialsProvider, AwsCredentialsProvider.class);
        Assert.assertEquals(credentialsProvider.getClass(), deserializedCredentialsProvider.getClass());
    }

    @Test
    public void testProxyConfigurationSerializationDeserialization() throws Exception {
        ProxyConfiguration proxyConfiguration = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create("http://localhost:8080")).username("username").password("password").build();
        String valueAsJson = this.objectMapper.writeValueAsString((Object)proxyConfiguration);
        ProxyConfiguration deserializedProxyConfiguration = (ProxyConfiguration)this.objectMapper.readValue(valueAsJson, ProxyConfiguration.class);
        Assert.assertEquals((Object)"localhost", (Object)deserializedProxyConfiguration.host());
        Assert.assertEquals((long)8080L, (long)deserializedProxyConfiguration.port());
        Assert.assertEquals((Object)"username", (Object)deserializedProxyConfiguration.username());
        Assert.assertEquals((Object)"password", (Object)deserializedProxyConfiguration.password());
    }

    @Test
    public void testHttpClientConfigurationSerializationDeserialization() throws Exception {
        AttributeMap attributeMap = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)Duration.parse("PT100S")).put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE, (Object)Duration.parse("PT30S")).put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)15).build();
        String valueAsJson = this.objectMapper.writeValueAsString((Object)attributeMap);
        AttributeMap deserializedAttributeMap = (AttributeMap)this.objectMapper.readValue(valueAsJson, AttributeMap.class);
        Assert.assertEquals((Object)Duration.parse("PT100S"), (Object)deserializedAttributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT));
        Assert.assertEquals((Object)Duration.parse("PT30S"), (Object)deserializedAttributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE));
        Assert.assertEquals((Object)15, (Object)deserializedAttributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS));
    }
}

