/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.io.aws2.kinesis.GetKinesisRecordsResult;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPointShardsFinder;
import org.apache.beam.sdk.io.aws2.kinesis.TransientKinesisException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.joda.time.Instant;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.kinesis.common.InitialPositionInStream;

@RunWith(value=JUnit4.class)
public class StartingPointShardsFinderTest {
    private static final String STREAM_NAME = "streamName";
    private SimplifiedKinesisClient kinesis = (SimplifiedKinesisClient)Mockito.mock(SimplifiedKinesisClient.class);
    private final Shard shard00 = this.createClosedShard("0000");
    private final Shard shard01 = this.createClosedShard("0001");
    private final Shard shard02 = (Shard)this.createClosedShard("0002").toBuilder().parentShardId("0000").build();
    private final Shard shard03 = (Shard)this.createClosedShard("0003").toBuilder().parentShardId("0000").build();
    private final Shard shard04 = (Shard)this.createClosedShard("0004").toBuilder().parentShardId("0001").build();
    private final Shard shard05 = (Shard)this.createClosedShard("0005").toBuilder().parentShardId("0001").build();
    private final Shard shard06 = (Shard)this.createClosedShard("0006").toBuilder().parentShardId("0003").adjacentParentShardId("0004").build();
    private final Shard shard07 = (Shard)this.createClosedShard("0007").toBuilder().parentShardId("0006").build();
    private final Shard shard08 = (Shard)this.createClosedShard("0008").toBuilder().parentShardId("0006").build();
    private final Shard shard09 = (Shard)this.createOpenShard("0009").toBuilder().parentShardId("0002").adjacentParentShardId("0007").build();
    private final Shard shard10 = (Shard)this.createOpenShard("0010").toBuilder().parentShardId("0008").adjacentParentShardId("0005").build();
    private final List<Shard> allShards = ImmutableList.of((Object)this.shard00, (Object)this.shard01, (Object)this.shard02, (Object)this.shard03, (Object)this.shard04, (Object)this.shard05, (Object)this.shard06, (Object)this.shard07, (Object)this.shard08, (Object)this.shard09, (Object)this.shard10);
    private StartingPointShardsFinder underTest = new StartingPointShardsFinder();

    @Test
    public void shouldFindFirstShardsWhenAllShardsAreValid() throws Exception {
        Instant timestampAtTheBeginning = new Instant();
        StartingPoint startingPointAtTheBeginning = new StartingPoint(timestampAtTheBeginning);
        for (Shard shard : this.allShards) {
            this.activeAtTimestamp(shard, timestampAtTheBeginning);
        }
        Mockito.when((Object)this.kinesis.listShards(STREAM_NAME)).thenReturn(this.allShards);
        Set shardsAtStartingPoint = this.underTest.findShardsAtStartingPoint(this.kinesis, STREAM_NAME, startingPointAtTheBeginning);
        Assertions.assertThat((Iterable)shardsAtStartingPoint).containsExactlyInAnyOrder((Object[])new Shard[]{this.shard00, this.shard01});
    }

    @Test
    public void shouldFind3StartingShardsInTheMiddle() throws Exception {
        Instant timestampAfterShards3And4Merge = new Instant();
        StartingPoint startingPointAfterFirstSplitsAndMerge = new StartingPoint(timestampAfterShards3And4Merge);
        this.expiredAtTimestamp(this.shard00, timestampAfterShards3And4Merge);
        this.expiredAtTimestamp(this.shard01, timestampAfterShards3And4Merge);
        this.activeAtTimestamp(this.shard02, timestampAfterShards3And4Merge);
        this.expiredAtTimestamp(this.shard03, timestampAfterShards3And4Merge);
        this.expiredAtTimestamp(this.shard04, timestampAfterShards3And4Merge);
        this.activeAtTimestamp(this.shard05, timestampAfterShards3And4Merge);
        this.activeAtTimestamp(this.shard06, timestampAfterShards3And4Merge);
        this.activeAtTimestamp(this.shard07, timestampAfterShards3And4Merge);
        this.activeAtTimestamp(this.shard08, timestampAfterShards3And4Merge);
        this.activeAtTimestamp(this.shard09, timestampAfterShards3And4Merge);
        this.activeAtTimestamp(this.shard10, timestampAfterShards3And4Merge);
        Mockito.when((Object)this.kinesis.listShards(STREAM_NAME)).thenReturn(this.allShards);
        Set shardsAtStartingPoint = this.underTest.findShardsAtStartingPoint(this.kinesis, STREAM_NAME, startingPointAfterFirstSplitsAndMerge);
        Assertions.assertThat((Iterable)shardsAtStartingPoint).containsExactlyInAnyOrder((Object[])new Shard[]{this.shard02, this.shard05, this.shard06});
    }

    @Test
    public void shouldFindLastShardWhenAllPreviousExpired() throws Exception {
        Instant timestampAtTheEnd = new Instant();
        StartingPoint startingPointAtTheEnd = new StartingPoint(timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard00, timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard01, timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard02, timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard03, timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard04, timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard05, timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard06, timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard07, timestampAtTheEnd);
        this.expiredAtTimestamp(this.shard08, timestampAtTheEnd);
        this.activeAtTimestamp(this.shard09, timestampAtTheEnd);
        this.activeAtTimestamp(this.shard10, timestampAtTheEnd);
        Mockito.when((Object)this.kinesis.listShards(STREAM_NAME)).thenReturn(this.allShards);
        Set shardsAtStartingPoint = this.underTest.findShardsAtStartingPoint(this.kinesis, STREAM_NAME, startingPointAtTheEnd);
        Assertions.assertThat((Iterable)shardsAtStartingPoint).containsExactlyInAnyOrder((Object[])new Shard[]{this.shard09, this.shard10});
    }

    @Test
    public void shouldFindLastShardsWhenLatestStartingPointRequested() throws Exception {
        StartingPoint latestStartingPoint = new StartingPoint(InitialPositionInStream.LATEST);
        Mockito.when((Object)this.kinesis.listShards(STREAM_NAME)).thenReturn(this.allShards);
        Set shardsAtStartingPoint = this.underTest.findShardsAtStartingPoint(this.kinesis, STREAM_NAME, latestStartingPoint);
        Assertions.assertThat((Iterable)shardsAtStartingPoint).containsExactlyInAnyOrder((Object[])new Shard[]{this.shard09, this.shard10});
    }

    @Test
    public void shouldFindEarliestShardsWhenTrimHorizonStartingPointRequested() throws Exception {
        StartingPoint trimHorizonStartingPoint = new StartingPoint(InitialPositionInStream.TRIM_HORIZON);
        Mockito.when((Object)this.kinesis.listShards(STREAM_NAME)).thenReturn(this.allShards);
        Set shardsAtStartingPoint = this.underTest.findShardsAtStartingPoint(this.kinesis, STREAM_NAME, trimHorizonStartingPoint);
        Assertions.assertThat((Iterable)shardsAtStartingPoint).containsExactlyInAnyOrder((Object[])new Shard[]{this.shard00, this.shard01});
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowExceptionWhenSuccessorsNotFoundForExpiredShard() throws Exception {
        StartingPoint latestStartingPoint = new StartingPoint(InitialPositionInStream.LATEST);
        Shard closedShard10 = (Shard)this.createClosedShard("0010").toBuilder().parentShardId("0008").adjacentParentShardId("0005").build();
        ImmutableList shards = ImmutableList.of((Object)this.shard00, (Object)this.shard01, (Object)this.shard02, (Object)this.shard03, (Object)this.shard04, (Object)this.shard05, (Object)this.shard06, (Object)this.shard07, (Object)this.shard08, (Object)this.shard09, (Object)closedShard10);
        Mockito.when((Object)this.kinesis.listShards(STREAM_NAME)).thenReturn((Object)shards);
        this.underTest.findShardsAtStartingPoint(this.kinesis, STREAM_NAME, latestStartingPoint);
    }

    private Shard createClosedShard(String shardId) {
        Shard shard = (Shard)Shard.builder().shardId(shardId).build();
        this.activeAtPoint(shard, ShardIteratorType.TRIM_HORIZON);
        this.expiredAtPoint(shard, ShardIteratorType.LATEST);
        return shard;
    }

    private Shard createOpenShard(String shardId) {
        Shard shard = (Shard)Shard.builder().shardId(shardId).build();
        this.activeAtPoint(shard, ShardIteratorType.TRIM_HORIZON);
        this.activeAtPoint(shard, ShardIteratorType.LATEST);
        return shard;
    }

    private void expiredAtTimestamp(Shard shard, Instant startTimestamp) {
        this.prepareShard(shard, null, ShardIteratorType.AT_TIMESTAMP, startTimestamp);
    }

    private void expiredAtPoint(Shard shard, ShardIteratorType shardIteratorType) {
        this.prepareShard(shard, null, shardIteratorType, null);
    }

    private void activeAtTimestamp(Shard shard, Instant startTimestamp) {
        this.prepareShard(shard, "timestampIterator-" + shard.shardId(), ShardIteratorType.AT_TIMESTAMP, startTimestamp);
    }

    private void activeAtPoint(Shard shard, ShardIteratorType shardIteratorType) {
        this.prepareShard(shard, shardIteratorType.toString() + shard.shardId(), shardIteratorType, null);
    }

    private void prepareShard(Shard shard, String nextIterator, ShardIteratorType shardIteratorType, Instant startTimestamp) {
        try {
            String shardIterator = shardIteratorType + shard.shardId() + "-current";
            if (shardIteratorType == ShardIteratorType.AT_TIMESTAMP) {
                Mockito.when((Object)this.kinesis.getShardIterator(STREAM_NAME, shard.shardId(), ShardIteratorType.AT_TIMESTAMP, null, startTimestamp)).thenReturn((Object)shardIterator);
            } else {
                Mockito.when((Object)this.kinesis.getShardIterator(STREAM_NAME, shard.shardId(), shardIteratorType, null, null)).thenReturn((Object)shardIterator);
            }
            GetKinesisRecordsResult result = new GetKinesisRecordsResult(Collections.emptyList(), nextIterator, 0L, STREAM_NAME, shard.shardId());
            Mockito.when((Object)this.kinesis.getRecords(shardIterator, STREAM_NAME, shard.shardId())).thenReturn((Object)result);
        }
        catch (TransientKinesisException e) {
            throw new RuntimeException(e);
        }
    }
}

