/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.aws2.kinesis.GetKinesisRecordsResult;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisClientThrottledException;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.apache.beam.sdk.io.aws2.kinesis.TransientKinesisException;
import org.assertj.core.api.Assertions;
import org.joda.time.Instant;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

@RunWith(value=MockitoJUnitRunner.class)
public class SimplifiedKinesisClientTest {
    private static final String STREAM = "stream";
    private static final String SHARD_1 = "shard-01";
    private static final String SHARD_2 = "shard-02";
    private static final String SHARD_3 = "shard-03";
    private static final String SHARD_ITERATOR = "iterator";
    private static final String SEQUENCE_NUMBER = "abc123";
    @Mock
    private KinesisClient kinesis;
    @Mock
    private CloudWatchClient cloudWatch;
    @InjectMocks
    private SimplifiedKinesisClient underTest;

    @Test
    public void shouldReturnIteratorStartingWithSequenceNumber() throws Exception {
        Mockito.when((Object)this.kinesis.getShardIterator((GetShardIteratorRequest)GetShardIteratorRequest.builder().streamName(STREAM).shardId(SHARD_1).shardIteratorType(ShardIteratorType.AT_SEQUENCE_NUMBER).startingSequenceNumber(SEQUENCE_NUMBER).build())).thenReturn((Object)((GetShardIteratorResponse)GetShardIteratorResponse.builder().shardIterator(SHARD_ITERATOR).build()));
        String stream = this.underTest.getShardIterator(STREAM, SHARD_1, ShardIteratorType.AT_SEQUENCE_NUMBER, SEQUENCE_NUMBER, null);
        Assertions.assertThat((String)stream).isEqualTo((Object)SHARD_ITERATOR);
    }

    @Test
    public void shouldReturnIteratorStartingWithTimestamp() throws Exception {
        Instant timestamp = Instant.now();
        Mockito.when((Object)this.kinesis.getShardIterator((GetShardIteratorRequest)GetShardIteratorRequest.builder().streamName(STREAM).shardId(SHARD_1).shardIteratorType(ShardIteratorType.AT_SEQUENCE_NUMBER).timestamp(TimeUtil.toJava((Instant)timestamp)).build())).thenReturn((Object)((GetShardIteratorResponse)GetShardIteratorResponse.builder().shardIterator(SHARD_ITERATOR).build()));
        String stream = this.underTest.getShardIterator(STREAM, SHARD_1, ShardIteratorType.AT_SEQUENCE_NUMBER, null, timestamp);
        Assertions.assertThat((String)stream).isEqualTo((Object)SHARD_ITERATOR);
    }

    @Test
    public void shouldHandleExpiredIterationExceptionForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)ExpiredIteratorException.builder().build(), ExpiredIteratorException.class);
    }

    @Test
    public void shouldHandleLimitExceededExceptionForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)LimitExceededException.builder().build(), KinesisClientThrottledException.class);
    }

    @Test
    public void shouldHandleProvisionedThroughputExceededExceptionForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)ProvisionedThroughputExceededException.builder().build(), KinesisClientThrottledException.class);
    }

    @Test
    public void shouldHandleServiceErrorForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)SdkServiceException.builder().build(), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleClientErrorForGetShardIterator() {
        this.shouldHandleGetShardIteratorError((Exception)SdkClientException.builder().build(), RuntimeException.class);
    }

    @Test
    public void shouldHandleUnexpectedExceptionForGetShardIterator() {
        this.shouldHandleGetShardIteratorError(new NullPointerException(), RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldHandleGetShardIteratorError(Exception thrownException, Class<? extends Exception> expectedExceptionClass) {
        GetShardIteratorRequest request = (GetShardIteratorRequest)GetShardIteratorRequest.builder().streamName(STREAM).shardId(SHARD_1).shardIteratorType(ShardIteratorType.LATEST).build();
        Mockito.when((Object)this.kinesis.getShardIterator(request)).thenThrow(new Throwable[]{thrownException});
        try {
            this.underTest.getShardIterator(STREAM, SHARD_1, ShardIteratorType.LATEST, null, null);
            Assertions.failBecauseExceptionWasNotThrown(expectedExceptionClass);
        }
        catch (Exception e) {
            try {
                Assertions.assertThat((Throwable)e).isExactlyInstanceOf(expectedExceptionClass);
            }
            catch (Throwable throwable) {
                Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
                throw throwable;
            }
            Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
        }
        Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
    }

    @Test
    public void shouldListAllShards() throws Exception {
        Shard shard1 = (Shard)Shard.builder().shardId(SHARD_1).build();
        Shard shard2 = (Shard)Shard.builder().shardId(SHARD_2).build();
        Shard shard3 = (Shard)Shard.builder().shardId(SHARD_3).build();
        Mockito.when((Object)this.kinesis.describeStream((DescribeStreamRequest)DescribeStreamRequest.builder().streamName(STREAM).exclusiveStartShardId(null).build())).thenReturn((Object)((DescribeStreamResponse)DescribeStreamResponse.builder().streamDescription(s -> s.shards(new Shard[]{shard1, shard2}).hasMoreShards(Boolean.valueOf(true))).build()));
        Mockito.when((Object)this.kinesis.describeStream((DescribeStreamRequest)DescribeStreamRequest.builder().streamName(STREAM).exclusiveStartShardId(SHARD_2).build())).thenReturn((Object)((DescribeStreamResponse)DescribeStreamResponse.builder().streamDescription(s -> s.shards(new Shard[]{shard3}).hasMoreShards(Boolean.valueOf(false))).build()));
        List shards = this.underTest.listShards(STREAM);
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldHandleExpiredIterationExceptionForShardListing() {
        this.shouldHandleShardListingError((Exception)ExpiredIteratorException.builder().build(), ExpiredIteratorException.class);
    }

    @Test
    public void shouldHandleLimitExceededExceptionForShardListing() {
        this.shouldHandleShardListingError((Exception)LimitExceededException.builder().build(), KinesisClientThrottledException.class);
    }

    @Test
    public void shouldHandleProvisionedThroughputExceededExceptionForShardListing() {
        this.shouldHandleShardListingError((Exception)ProvisionedThroughputExceededException.builder().build(), KinesisClientThrottledException.class);
    }

    @Test
    public void shouldHandleServiceErrorForShardListing() {
        this.shouldHandleShardListingError((Exception)SdkServiceException.builder().build(), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleClientErrorForShardListing() {
        this.shouldHandleShardListingError((Exception)SdkClientException.builder().build(), RuntimeException.class);
    }

    @Test
    public void shouldHandleUnexpectedExceptionForShardListing() {
        this.shouldHandleShardListingError(new NullPointerException(), RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldHandleShardListingError(Exception thrownException, Class<? extends Exception> expectedExceptionClass) {
        Mockito.when((Object)this.kinesis.describeStream((DescribeStreamRequest)Matchers.any(DescribeStreamRequest.class))).thenThrow(new Throwable[]{thrownException});
        try {
            this.underTest.listShards(STREAM);
            Assertions.failBecauseExceptionWasNotThrown(expectedExceptionClass);
        }
        catch (Exception e) {
            try {
                Assertions.assertThat((Throwable)e).isExactlyInstanceOf(expectedExceptionClass);
            }
            catch (Throwable throwable) {
                Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
                throw throwable;
            }
            Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
        }
        Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
    }

    @Test
    public void shouldCountBytesWhenSingleDataPointReturned() throws Exception {
        Instant countSince = new Instant((Object)"2017-04-06T10:00:00.000Z");
        Instant countTo = new Instant((Object)"2017-04-06T11:00:00.000Z");
        Minutes periodTime = Minutes.minutesBetween((ReadableInstant)countSince, (ReadableInstant)countTo);
        GetMetricStatisticsRequest metricStatisticsRequest = this.underTest.createMetricStatisticsRequest(STREAM, countSince, countTo, periodTime);
        GetMetricStatisticsResponse result = (GetMetricStatisticsResponse)GetMetricStatisticsResponse.builder().datapoints(new Datapoint[]{(Datapoint)Datapoint.builder().sum(Double.valueOf(1.0)).build()}).build();
        Mockito.when((Object)this.cloudWatch.getMetricStatistics(metricStatisticsRequest)).thenReturn((Object)result);
        long backlogBytes = this.underTest.getBacklogBytes(STREAM, countSince, countTo);
        Assertions.assertThat((long)backlogBytes).isEqualTo(1L);
    }

    @Test
    public void shouldCountBytesWhenMultipleDataPointsReturned() throws Exception {
        Instant countSince = new Instant((Object)"2017-04-06T10:00:00.000Z");
        Instant countTo = new Instant((Object)"2017-04-06T11:00:00.000Z");
        Minutes periodTime = Minutes.minutesBetween((ReadableInstant)countSince, (ReadableInstant)countTo);
        GetMetricStatisticsRequest metricStatisticsRequest = this.underTest.createMetricStatisticsRequest(STREAM, countSince, countTo, periodTime);
        GetMetricStatisticsResponse result = (GetMetricStatisticsResponse)GetMetricStatisticsResponse.builder().datapoints(new Datapoint[]{(Datapoint)Datapoint.builder().sum(Double.valueOf(1.0)).build(), (Datapoint)Datapoint.builder().sum(Double.valueOf(3.0)).build(), (Datapoint)Datapoint.builder().sum(Double.valueOf(2.0)).build()}).build();
        Mockito.when((Object)this.cloudWatch.getMetricStatistics(metricStatisticsRequest)).thenReturn((Object)result);
        long backlogBytes = this.underTest.getBacklogBytes(STREAM, countSince, countTo);
        Assertions.assertThat((long)backlogBytes).isEqualTo(6L);
    }

    @Test
    public void shouldNotCallCloudWatchWhenSpecifiedPeriodTooShort() throws Exception {
        Instant countSince = new Instant((Object)"2017-04-06T10:00:00.000Z");
        Instant countTo = new Instant((Object)"2017-04-06T10:00:02.000Z");
        long backlogBytes = this.underTest.getBacklogBytes(STREAM, countSince, countTo);
        Assertions.assertThat((long)backlogBytes).isEqualTo(0L);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.cloudWatch});
    }

    @Test
    public void shouldHandleLimitExceededExceptionForGetBacklogBytes() {
        this.shouldHandleGetBacklogBytesError((Exception)LimitExceededException.builder().build(), KinesisClientThrottledException.class);
    }

    @Test
    public void shouldHandleProvisionedThroughputExceededExceptionForGetBacklogBytes() {
        this.shouldHandleGetBacklogBytesError((Exception)ProvisionedThroughputExceededException.builder().build(), KinesisClientThrottledException.class);
    }

    @Test
    public void shouldHandleServiceErrorForGetBacklogBytes() {
        this.shouldHandleGetBacklogBytesError((Exception)SdkServiceException.builder().build(), TransientKinesisException.class);
    }

    @Test
    public void shouldHandleClientErrorForGetBacklogBytes() {
        this.shouldHandleGetBacklogBytesError((Exception)SdkClientException.builder().build(), RuntimeException.class);
    }

    @Test
    public void shouldHandleUnexpectedExceptionForGetBacklogBytes() {
        this.shouldHandleGetBacklogBytesError(new NullPointerException(), RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldHandleGetBacklogBytesError(Exception thrownException, Class<? extends Exception> expectedExceptionClass) {
        Instant countSince = new Instant((Object)"2017-04-06T10:00:00.000Z");
        Instant countTo = new Instant((Object)"2017-04-06T11:00:00.000Z");
        Minutes periodTime = Minutes.minutesBetween((ReadableInstant)countSince, (ReadableInstant)countTo);
        GetMetricStatisticsRequest metricStatisticsRequest = this.underTest.createMetricStatisticsRequest(STREAM, countSince, countTo, periodTime);
        Mockito.when((Object)this.cloudWatch.getMetricStatistics(metricStatisticsRequest)).thenThrow(new Throwable[]{thrownException});
        try {
            this.underTest.getBacklogBytes(STREAM, countSince, countTo);
            Assertions.failBecauseExceptionWasNotThrown(expectedExceptionClass);
        }
        catch (Exception e) {
            try {
                Assertions.assertThat((Throwable)e).isExactlyInstanceOf(expectedExceptionClass);
            }
            catch (Throwable throwable) {
                Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
                throw throwable;
            }
            Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
        }
        Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
    }

    @Test
    public void shouldReturnLimitedNumberOfRecords() throws Exception {
        Integer limit = 100;
        ((KinesisClient)Mockito.doAnswer(invocation -> {
            GetRecordsRequest request = (GetRecordsRequest)invocation.getArguments()[0];
            List<Record> records = this.generateRecords(request.limit());
            return (GetRecordsResponse)GetRecordsResponse.builder().records(records).millisBehindLatest(Long.valueOf(1000L)).build();
        }).when((Object)this.kinesis)).getRecords((GetRecordsRequest)Matchers.any(GetRecordsRequest.class));
        GetKinesisRecordsResult result = this.underTest.getRecords(SHARD_ITERATOR, STREAM, SHARD_1, limit);
        Assertions.assertThat((int)result.getRecords().size()).isEqualTo((Object)limit);
    }

    private List<Record> generateRecords(int num) {
        ArrayList<Record> records = new ArrayList<Record>();
        for (int i = 0; i < num; ++i) {
            byte[] value = new byte[1024];
            Arrays.fill(value, (byte)i);
            records.add((Record)Record.builder().sequenceNumber(String.valueOf(i)).partitionKey("key").data(SdkBytes.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(value))).build());
        }
        return records;
    }
}

