/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.TransientKinesisException;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

@RunWith(value=MockitoJUnitRunner.class)
public class ShardCheckpointTest {
    private static final String AT_SEQUENCE_SHARD_IT = "AT_SEQUENCE_SHARD_IT";
    private static final String AFTER_SEQUENCE_SHARD_IT = "AFTER_SEQUENCE_SHARD_IT";
    private static final String STREAM_NAME = "STREAM";
    private static final String SHARD_ID = "SHARD_ID";
    @Mock
    private SimplifiedKinesisClient client;

    @Before
    public void setUp() throws IOException, TransientKinesisException {
        Mockito.when((Object)this.client.getShardIterator((String)Matchers.eq((Object)STREAM_NAME), (String)Matchers.eq((Object)SHARD_ID), (ShardIteratorType)Matchers.eq((Object)ShardIteratorType.AT_SEQUENCE_NUMBER), ArgumentMatchers.anyString(), (Instant)Matchers.isNull(Instant.class))).thenReturn((Object)AT_SEQUENCE_SHARD_IT);
        Mockito.when((Object)this.client.getShardIterator((String)Matchers.eq((Object)STREAM_NAME), (String)Matchers.eq((Object)SHARD_ID), (ShardIteratorType)Matchers.eq((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER), ArgumentMatchers.anyString(), (Instant)Matchers.isNull(Instant.class))).thenReturn((Object)AFTER_SEQUENCE_SHARD_IT);
    }

    @Test
    public void testProvidingShardIterator() throws IOException, TransientKinesisException {
        Assertions.assertThat((String)this.checkpoint(ShardIteratorType.AT_SEQUENCE_NUMBER, "100", null).getShardIterator(this.client)).isEqualTo((Object)AT_SEQUENCE_SHARD_IT);
        Assertions.assertThat((String)this.checkpoint(ShardIteratorType.AFTER_SEQUENCE_NUMBER, "100", null).getShardIterator(this.client)).isEqualTo((Object)AFTER_SEQUENCE_SHARD_IT);
        Assertions.assertThat((String)this.checkpoint(ShardIteratorType.AT_SEQUENCE_NUMBER, "100", 10L).getShardIterator(this.client)).isEqualTo((Object)AT_SEQUENCE_SHARD_IT);
        Assertions.assertThat((String)this.checkpoint(ShardIteratorType.AFTER_SEQUENCE_NUMBER, "100", 10L).getShardIterator(this.client)).isEqualTo((Object)AT_SEQUENCE_SHARD_IT);
    }

    @Test
    public void testComparisonWithExtendedSequenceNumber() {
        Assertions.assertThat((boolean)new ShardCheckpoint("", "", new StartingPoint(InitialPositionInStream.LATEST)).isBeforeOrAt(this.recordWith(new ExtendedSequenceNumber("100", Long.valueOf(0L))))).isTrue();
        Assertions.assertThat((boolean)new ShardCheckpoint("", "", new StartingPoint(InitialPositionInStream.TRIM_HORIZON)).isBeforeOrAt(this.recordWith(new ExtendedSequenceNumber("100", Long.valueOf(0L))))).isTrue();
        Assertions.assertThat((boolean)this.checkpoint(ShardIteratorType.AFTER_SEQUENCE_NUMBER, "10", 1L).isBeforeOrAt(this.recordWith(new ExtendedSequenceNumber("100", Long.valueOf(0L))))).isTrue();
        Assertions.assertThat((boolean)this.checkpoint(ShardIteratorType.AT_SEQUENCE_NUMBER, "100", 0L).isBeforeOrAt(this.recordWith(new ExtendedSequenceNumber("100", Long.valueOf(0L))))).isTrue();
        Assertions.assertThat((boolean)this.checkpoint(ShardIteratorType.AFTER_SEQUENCE_NUMBER, "100", 0L).isBeforeOrAt(this.recordWith(new ExtendedSequenceNumber("100", Long.valueOf(0L))))).isFalse();
        Assertions.assertThat((boolean)this.checkpoint(ShardIteratorType.AT_SEQUENCE_NUMBER, "100", 1L).isBeforeOrAt(this.recordWith(new ExtendedSequenceNumber("100", Long.valueOf(0L))))).isFalse();
        Assertions.assertThat((boolean)this.checkpoint(ShardIteratorType.AFTER_SEQUENCE_NUMBER, "100", 0L).isBeforeOrAt(this.recordWith(new ExtendedSequenceNumber("99", Long.valueOf(1L))))).isFalse();
    }

    @Test
    public void testComparisonWithTimestamp() {
        DateTime referenceTimestamp = DateTime.now();
        Assertions.assertThat((boolean)this.checkpoint(ShardIteratorType.AT_TIMESTAMP, referenceTimestamp.toInstant()).isBeforeOrAt(this.recordWith(referenceTimestamp.minusMillis(10).toInstant()))).isFalse();
        Assertions.assertThat((boolean)this.checkpoint(ShardIteratorType.AT_TIMESTAMP, referenceTimestamp.toInstant()).isBeforeOrAt(this.recordWith(referenceTimestamp.toInstant()))).isTrue();
        Assertions.assertThat((boolean)this.checkpoint(ShardIteratorType.AT_TIMESTAMP, referenceTimestamp.toInstant()).isBeforeOrAt(this.recordWith(referenceTimestamp.plusMillis(10).toInstant()))).isTrue();
    }

    private KinesisRecord recordWith(ExtendedSequenceNumber extendedSequenceNumber) {
        KinesisRecord record = (KinesisRecord)Mockito.mock(KinesisRecord.class);
        Mockito.when((Object)record.getExtendedSequenceNumber()).thenReturn((Object)extendedSequenceNumber);
        return record;
    }

    private ShardCheckpoint checkpoint(ShardIteratorType iteratorType, String sequenceNumber, Long subSequenceNumber) {
        return new ShardCheckpoint(STREAM_NAME, SHARD_ID, iteratorType, sequenceNumber, subSequenceNumber);
    }

    private KinesisRecord recordWith(Instant approximateArrivalTimestamp) {
        KinesisRecord record = (KinesisRecord)Mockito.mock(KinesisRecord.class);
        Mockito.when((Object)record.getApproximateArrivalTimestamp()).thenReturn((Object)approximateArrivalTimestamp);
        return record;
    }

    private ShardCheckpoint checkpoint(ShardIteratorType iteratorType, Instant timestamp) {
        return new ShardCheckpoint(STREAM_NAME, SHARD_ID, iteratorType, timestamp);
    }
}

