/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.RecordFilter;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RecordFilterTest {
    @Mock
    private ShardCheckpoint checkpoint;
    @Mock
    private KinesisRecord record1;
    @Mock
    private KinesisRecord record2;
    @Mock
    private KinesisRecord record3;
    @Mock
    private KinesisRecord record4;
    @Mock
    private KinesisRecord record5;

    @Test
    public void shouldFilterOutRecordsBeforeOrAtCheckpoint() {
        Mockito.when((Object)this.checkpoint.isBeforeOrAt(this.record1)).thenReturn((Object)false);
        Mockito.when((Object)this.checkpoint.isBeforeOrAt(this.record2)).thenReturn((Object)true);
        Mockito.when((Object)this.checkpoint.isBeforeOrAt(this.record3)).thenReturn((Object)true);
        Mockito.when((Object)this.checkpoint.isBeforeOrAt(this.record4)).thenReturn((Object)false);
        Mockito.when((Object)this.checkpoint.isBeforeOrAt(this.record5)).thenReturn((Object)true);
        ArrayList records = Lists.newArrayList((Object[])new KinesisRecord[]{this.record1, this.record2, this.record3, this.record4, this.record5});
        RecordFilter underTest = new RecordFilter();
        List retainedRecords = underTest.apply((List)records, this.checkpoint);
        Assertions.assertThat((List)retainedRecords).containsOnly((Object[])new KinesisRecord[]{this.record2, this.record3, this.record5});
    }

    @Test
    public void shouldNotFailOnEmptyList() {
        List records = Collections.emptyList();
        RecordFilter underTest = new RecordFilter();
        List retainedRecords = underTest.apply(records, this.checkpoint);
        Assertions.assertThat((List)retainedRecords).isEmpty();
    }
}

