/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.io.aws2.kinesis.AmazonKinesisMock;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.DateTime;

public class KinesisServiceMock {
    private static KinesisServiceMock instance;
    private String existedStream;
    private AtomicInteger addedRecords = new AtomicInteger(0);
    private AtomicInteger seqNumber = new AtomicInteger(0);
    private List<List<AmazonKinesisMock.TestData>> shardedData;

    private KinesisServiceMock() {
    }

    public static synchronized KinesisServiceMock getInstance() {
        if (instance == null) {
            instance = new KinesisServiceMock();
        }
        return instance;
    }

    public synchronized void init(String stream, int shardsNum) {
        this.existedStream = stream;
        this.addedRecords.set(0);
        this.seqNumber.set(0);
        this.shardedData = Lists.newArrayList();
        for (int i = 0; i < shardsNum; ++i) {
            ArrayList shardData = Lists.newArrayList();
            this.shardedData.add(shardData);
        }
    }

    public AtomicInteger getAddedRecords() {
        return this.addedRecords;
    }

    public String getExistedStream() {
        return this.existedStream;
    }

    public synchronized void addShardedData(ByteBuffer data, DateTime arrival) {
        String dataString = StandardCharsets.UTF_8.decode(data).toString();
        List<AmazonKinesisMock.TestData> shardData = this.shardedData.get(0);
        this.seqNumber.incrementAndGet();
        AmazonKinesisMock.TestData testData = new AmazonKinesisMock.TestData(dataString, arrival.toInstant(), Integer.toString(this.seqNumber.get()));
        shardData.add(testData);
        this.addedRecords.incrementAndGet();
    }

    public synchronized List<List<AmazonKinesisMock.TestData>> getShardedData() {
        return this.shardedData;
    }
}

