/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KinesisReaderCheckpointTest {
    @Mock
    private ShardCheckpoint a;
    @Mock
    private ShardCheckpoint b;
    @Mock
    private ShardCheckpoint c;
    private KinesisReaderCheckpoint checkpoint;

    @Before
    public void setUp() {
        this.checkpoint = new KinesisReaderCheckpoint(Arrays.asList(this.a, this.b, this.c));
    }

    @Test
    public void splitsCheckpointAccordingly() {
        this.verifySplitInto(1);
        this.verifySplitInto(2);
        this.verifySplitInto(3);
        this.verifySplitInto(4);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void isImmutable() {
        Iterator iterator = this.checkpoint.iterator();
        iterator.remove();
    }

    private void verifySplitInto(int size) {
        List split = this.checkpoint.splitInto(size);
        Assertions.assertThat((Iterable)Iterables.concat((Iterable)split)).containsOnly((Object[])new ShardCheckpoint[]{this.a, this.b, this.c});
        Assertions.assertThat((List)split).hasSize(Math.min(size, 3));
    }
}

