/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.HashSet;
import org.apache.beam.sdk.io.aws2.kinesis.DynamicCheckpointGenerator;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPointShardsFinder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.kinesis.common.InitialPositionInStream;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Shard.class})
public class DynamicCheckpointGeneratorTest {
    @Mock
    private SimplifiedKinesisClient kinesisClient;
    @Mock
    private StartingPointShardsFinder startingPointShardsFinder;
    @Mock
    private Shard shard1;
    @Mock
    private Shard shard2;
    @Mock
    private Shard shard3;

    @Test
    public void shouldMapAllShardsToCheckpoints() throws Exception {
        Mockito.when((Object)this.shard1.shardId()).thenReturn((Object)"shard-01");
        Mockito.when((Object)this.shard2.shardId()).thenReturn((Object)"shard-02");
        Mockito.when((Object)this.shard3.shardId()).thenReturn((Object)"shard-03");
        HashSet shards = Sets.newHashSet((Object[])new Shard[]{this.shard1, this.shard2, this.shard3});
        StartingPoint startingPoint = new StartingPoint(InitialPositionInStream.LATEST);
        Mockito.when((Object)this.startingPointShardsFinder.findShardsAtStartingPoint(this.kinesisClient, "stream", startingPoint)).thenReturn((Object)shards);
        DynamicCheckpointGenerator underTest = new DynamicCheckpointGenerator("stream", startingPoint, this.startingPointShardsFinder);
        KinesisReaderCheckpoint checkpoint = underTest.generate(this.kinesisClient);
        Assertions.assertThat((Iterable)checkpoint).hasSize(3);
    }

    @Test
    public void shouldMapAllValidShardsToCheckpoints() throws Exception {
        Mockito.when((Object)this.shard1.shardId()).thenReturn((Object)"shard-01");
        Mockito.when((Object)this.shard2.shardId()).thenReturn((Object)"shard-02");
        Mockito.when((Object)this.shard3.shardId()).thenReturn((Object)"shard-03");
        String streamName = "stream";
        HashSet shards = Sets.newHashSet((Object[])new Shard[]{this.shard1, this.shard2});
        StartingPoint startingPoint = new StartingPoint(InitialPositionInStream.LATEST);
        Mockito.when((Object)this.startingPointShardsFinder.findShardsAtStartingPoint(this.kinesisClient, "stream", startingPoint)).thenReturn((Object)shards);
        DynamicCheckpointGenerator underTest = new DynamicCheckpointGenerator(streamName, startingPoint, this.startingPointShardsFinder);
        KinesisReaderCheckpoint checkpoint = underTest.generate(this.kinesisClient);
        ((IterableAssert)Assertions.assertThat((Iterable)checkpoint).hasSize(2)).doesNotContain((Object[])new ShardCheckpoint[]{new ShardCheckpoint(streamName, this.shard3.shardId(), startingPoint)});
    }
}

