/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.aws2.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import org.mockito.Mockito;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;

class AmazonKinesisMock
implements KinesisClient {
    private final List<List<Record>> shardedData;
    private final int numberOfRecordsPerGet;
    private int rateLimitDescribeStream = 0;

    public AmazonKinesisMock(List<List<Record>> shardedData, int numberOfRecordsPerGet) {
        this.shardedData = shardedData;
        this.numberOfRecordsPerGet = numberOfRecordsPerGet;
    }

    public AmazonKinesisMock withRateLimitedDescribeStream(int rateLimitDescribeStream) {
        this.rateLimitDescribeStream = rateLimitDescribeStream;
        return this;
    }

    public String serviceName() {
        return null;
    }

    public void close() {
    }

    public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) {
        List shardIteratorParts = Splitter.on((char)':').splitToList((CharSequence)getRecordsRequest.shardIterator());
        int shardId = Integer.parseInt((String)shardIteratorParts.get(0));
        int startingRecord = Integer.parseInt((String)shardIteratorParts.get(1));
        List<Record> shardData = this.shardedData.get(shardId);
        int toIndex = Math.min(startingRecord + this.numberOfRecordsPerGet, shardData.size());
        int fromIndex = Math.min(startingRecord, toIndex);
        return (GetRecordsResponse)GetRecordsResponse.builder().records(shardData.subList(fromIndex, toIndex)).nextShardIterator(String.format("%s:%s", shardId, toIndex)).millisBehindLatest(Long.valueOf(0L)).build();
    }

    public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        ShardIteratorType shardIteratorType = getShardIteratorRequest.shardIteratorType();
        if (shardIteratorType != ShardIteratorType.TRIM_HORIZON) {
            throw new RuntimeException("Not implemented");
        }
        String shardIterator = String.format("%s:%s", getShardIteratorRequest.shardId(), 0);
        return (GetShardIteratorResponse)GetShardIteratorResponse.builder().shardIterator(shardIterator).build();
    }

    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) {
        if (this.rateLimitDescribeStream-- > 0) {
            throw (LimitExceededException)LimitExceededException.builder().message("DescribeStream rate limit exceeded").build();
        }
        int nextShardId = 0;
        if (describeStreamRequest.exclusiveStartShardId() != null) {
            nextShardId = Integer.parseInt(describeStreamRequest.exclusiveStartShardId()) + 1;
        }
        boolean hasMoreShards = nextShardId + 1 < this.shardedData.size();
        ArrayList<Shard> shards = new ArrayList<Shard>();
        if (nextShardId < this.shardedData.size()) {
            shards.add((Shard)Shard.builder().shardId(Integer.toString(nextShardId)).build());
        }
        DescribeStreamResponse.Builder builder = DescribeStreamResponse.builder().streamDescription(s -> s.hasMoreShards(Boolean.valueOf(hasMoreShards)).shards((Collection)shards).streamName(describeStreamRequest.streamName()));
        builder.sdkHttpResponse((SdkHttpResponse)SdkHttpResponse.builder().statusCode(200).build());
        return (DescribeStreamResponse)builder.build();
    }

    public AddTagsToStreamResponse addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DeleteStreamResponse deleteStream(DeleteStreamRequest deleteStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DescribeLimitsResponse describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DescribeStreamConsumerResponse describeStreamConsumer(DescribeStreamConsumerRequest describeStreamConsumerRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DescribeStreamSummaryResponse describeStreamSummary(DescribeStreamSummaryRequest describeStreamSummaryRequest) {
        throw new RuntimeException("Not implemented");
    }

    public DisableEnhancedMonitoringResponse disableEnhancedMonitoring(DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) {
        throw new RuntimeException("Not implemented");
    }

    public EnableEnhancedMonitoringResponse enableEnhancedMonitoring(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) {
        throw new RuntimeException("Not implemented");
    }

    public IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) {
        throw new RuntimeException("Not implemented");
    }

    public ListShardsResponse listShards(ListShardsRequest listShardsRequest) {
        throw new RuntimeException("Not implemented");
    }

    public ListStreamConsumersResponse listStreamConsumers(ListStreamConsumersRequest listStreamConsumersRequest) {
        throw new RuntimeException("Not implemented");
    }

    public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) {
        throw new RuntimeException("Not implemented");
    }

    public ListStreamsResponse listStreams() {
        throw new RuntimeException("Not implemented");
    }

    public ListTagsForStreamResponse listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public MergeShardsResponse mergeShards(MergeShardsRequest mergeShardsRequest) {
        throw new RuntimeException("Not implemented");
    }

    public PutRecordResponse putRecord(PutRecordRequest putRecordRequest) {
        throw new RuntimeException("Not implemented");
    }

    public PutRecordsResponse putRecords(PutRecordsRequest putRecordsRequest) {
        throw new RuntimeException("Not implemented");
    }

    public RegisterStreamConsumerResponse registerStreamConsumer(RegisterStreamConsumerRequest registerStreamConsumerRequest) {
        throw new RuntimeException("Not implemented");
    }

    public RemoveTagsFromStreamResponse removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest) {
        throw new RuntimeException("Not implemented");
    }

    public SplitShardResponse splitShard(SplitShardRequest splitShardRequest) {
        throw new RuntimeException("Not implemented");
    }

    public StartStreamEncryptionResponse startStreamEncryption(StartStreamEncryptionRequest startStreamEncryptionRequest) {
        throw new RuntimeException("Not implemented");
    }

    public StopStreamEncryptionResponse stopStreamEncryption(StopStreamEncryptionRequest stopStreamEncryptionRequest) {
        throw new RuntimeException("Not implemented");
    }

    public UpdateShardCountResponse updateShardCount(UpdateShardCountRequest updateShardCountRequest) {
        throw new RuntimeException("Not implemented");
    }

    static class Provider
    implements AWSClientsProvider {
        private final List<List<TestData>> shardedData;
        private final int numberOfRecordsPerGet;
        private int rateLimitDescribeStream = 0;

        public Provider(List<List<TestData>> shardedData, int numberOfRecordsPerGet) {
            this.shardedData = shardedData;
            this.numberOfRecordsPerGet = numberOfRecordsPerGet;
        }

        public Provider withRateLimitedDescribeStream(int rateLimitDescribeStream) {
            this.rateLimitDescribeStream = rateLimitDescribeStream;
            return this;
        }

        public KinesisClient getKinesisClient() {
            return new AmazonKinesisMock(this.shardedData.stream().map(testDatas -> Lists.transform((List)testDatas, TestData::convertToRecord)).collect(Collectors.toList()), this.numberOfRecordsPerGet).withRateLimitedDescribeStream(this.rateLimitDescribeStream);
        }

        public CloudWatchClient getCloudWatchClient() {
            return (CloudWatchClient)Mockito.mock(CloudWatchClient.class);
        }
    }

    static class TestData
    implements Serializable {
        private final String data;
        private final Instant arrivalTimestamp;
        private final String sequenceNumber;

        public TestData(KinesisRecord record) {
            this(new String(record.getData().array(), StandardCharsets.UTF_8), record.getApproximateArrivalTimestamp(), record.getSequenceNumber());
        }

        public TestData(String data, Instant arrivalTimestamp, String sequenceNumber) {
            this.data = data;
            this.arrivalTimestamp = arrivalTimestamp;
            this.sequenceNumber = sequenceNumber;
        }

        public Record convertToRecord() {
            return (Record)Record.builder().approximateArrivalTimestamp(TimeUtil.toJava((Instant)this.arrivalTimestamp)).data(SdkBytes.fromByteArray((byte[])this.data.getBytes(StandardCharsets.UTF_8))).sequenceNumber(this.sequenceNumber).partitionKey("").build();
        }

        public boolean equals(@Nullable Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this);
        }

        public String toString() {
            return "TestData{data='" + this.data + '\'' + ", arrivalTimestamp=" + this.arrivalTimestamp + ", sequenceNumber='" + this.sequenceNumber + '\'' + '}';
        }
    }
}

