/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Rule;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

class DynamoDBIOTestHelper
implements Serializable {
    private static final String DYNAMODB_LOCAL_VERSION = "1.13.3";
    @Rule
    public static GenericContainer dynamoContainer = new GenericContainer(DockerImageName.parse((String)"amazon/dynamodb-local").withTag("1.13.3")).withExposedPorts(new Integer[]{8000});
    private static DynamoDbClient dynamoDBClient;
    static final String ATTR_NAME_1 = "hashKey1";
    static final String ATTR_NAME_2 = "rangeKey2";

    DynamoDBIOTestHelper() {
    }

    static void startServerClient() {
        dynamoContainer.start();
        if (dynamoDBClient == null) {
            dynamoDBClient = DynamoDBIOTestHelper.getDynamoDBClient();
        }
    }

    static void stopServerClient(String tableName) {
        if (dynamoDBClient != null) {
            dynamoDBClient.close();
        }
        dynamoContainer.stop();
    }

    static DynamoDbClient getDynamoDBClient() {
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().endpointOverride(URI.create(DynamoDBIOTestHelper.getContainerEndpoint()))).region(Region.US_EAST_1)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"accessKey", (String)"secretKey")))).build();
    }

    static List<Map<String, AttributeValue>> generateTestData(String tableName, int numOfItems) {
        BatchWriteItemRequest batchWriteItemRequest = DynamoDBIOTestHelper.generateBatchWriteItemRequest(tableName, numOfItems);
        dynamoDBClient.batchWriteItem(batchWriteItemRequest);
        ScanResponse scanResult = dynamoDBClient.scan((ScanRequest)ScanRequest.builder().tableName(tableName).build());
        List items = scanResult.items();
        Assert.assertEquals((long)numOfItems, (long)items.size());
        return items;
    }

    static BatchWriteItemRequest generateBatchWriteItemRequest(String tableName, int numOfItems) {
        BatchWriteItemRequest batchWriteItemRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems((Map)ImmutableMap.of((Object)tableName, DynamoDBIOTestHelper.generateWriteRequests(numOfItems))).build();
        return batchWriteItemRequest;
    }

    static List<WriteRequest> generateWriteRequests(int numOfItem) {
        ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>();
        for (int i = 1; i <= numOfItem; ++i) {
            WriteRequest writeRequest = (WriteRequest)WriteRequest.builder().putRequest(DynamoDBIOTestHelper.generatePutRequest("hashKeyDataStr_" + i, "1000" + i)).build();
            writeRequests.add(writeRequest);
        }
        return writeRequests;
    }

    private static PutRequest generatePutRequest(String hashKeyData, String rangeKeyData) {
        ImmutableMap attrValueMap = ImmutableMap.of((Object)ATTR_NAME_1, (Object)((AttributeValue)AttributeValue.builder().s(hashKeyData).build()), (Object)ATTR_NAME_2, (Object)((AttributeValue)AttributeValue.builder().n(rangeKeyData).build()));
        PutRequest.Builder putRequestBuilder = PutRequest.builder();
        putRequestBuilder.item((Map)attrValueMap);
        return (PutRequest)putRequestBuilder.build();
    }

    static List<Map<String, AttributeValue>> readDataFromTable(String tableName) {
        ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(tableName).build();
        ScanResponse scanResponse = dynamoDBClient.scan(scanRequest);
        return scanResponse.items();
    }

    static void deleteTestTable(String tableName) {
        DeleteTableRequest request = (DeleteTableRequest)DeleteTableRequest.builder().tableName(tableName).build();
        dynamoDBClient.deleteTable(request);
    }

    static void createTestTable(String tableName) {
        CreateTableResponse res = DynamoDBIOTestHelper.createDynamoTable(tableName);
        TableDescription tableDesc = res.tableDescription();
        Assert.assertEquals((Object)tableName, (Object)tableDesc.tableName());
        Assert.assertTrue((boolean)tableDesc.keySchema().toString().contains(ATTR_NAME_1));
        Assert.assertTrue((boolean)tableDesc.keySchema().toString().contains(ATTR_NAME_2));
        Assert.assertEquals((Object)tableDesc.provisionedThroughput().readCapacityUnits(), (Object)1000L);
        Assert.assertEquals((Object)tableDesc.provisionedThroughput().writeCapacityUnits(), (Object)1000L);
        Assert.assertEquals((Object)TableStatus.ACTIVE, (Object)tableDesc.tableStatus());
        Assert.assertEquals((Object)("arn:aws:dynamodb:ddblocal:000000000000:table/" + tableName), (Object)tableDesc.tableArn());
        ListTablesResponse tables = dynamoDBClient.listTables();
        Assert.assertEquals((long)1L, (long)tables.tableNames().size());
    }

    private static CreateTableResponse createDynamoTable(String tableName) {
        ImmutableList attributeDefinitions = ImmutableList.of((Object)((AttributeDefinition)AttributeDefinition.builder().attributeName(ATTR_NAME_1).attributeType(ScalarAttributeType.S).build()), (Object)((AttributeDefinition)AttributeDefinition.builder().attributeName(ATTR_NAME_2).attributeType(ScalarAttributeType.N).build()));
        ImmutableList ks = ImmutableList.of((Object)((KeySchemaElement)KeySchemaElement.builder().attributeName(ATTR_NAME_1).keyType(KeyType.HASH).build()), (Object)((KeySchemaElement)KeySchemaElement.builder().attributeName(ATTR_NAME_2).keyType(KeyType.RANGE).build()));
        ProvisionedThroughput provisionedthroughput = (ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(1000L)).writeCapacityUnits(Long.valueOf(1000L)).build();
        CreateTableRequest request = (CreateTableRequest)CreateTableRequest.builder().tableName(tableName).attributeDefinitions((Collection)attributeDefinitions).keySchema((Collection)ks).provisionedThroughput(provisionedthroughput).build();
        return dynamoDBClient.createTable(request);
    }

    private static String getContainerEndpoint() {
        String address;
        String ipAddress = address = dynamoContainer.getContainerIpAddress();
        try {
            ipAddress = InetAddress.getByName(address).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        ipAddress = ipAddress + ".nip.io";
        while (true) {
            try {
                InetAddress.getAllByName(ipAddress);
            }
            catch (UnknownHostException unknownHostException) {
                continue;
            }
            break;
        }
        return "http://" + ipAddress + ":" + dynamoContainer.getFirstMappedPort();
    }
}

