/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

class SqsUnboundedReader
extends UnboundedSource.UnboundedReader<SqsMessage>
implements Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized int MAX_NUMBER_OF_MESSAGES = 10;
    private final @UnknownKeyFor @NonNull @Initialized SqsUnboundedSource source;
    private @UnknownKeyFor @NonNull @Initialized SqsMessage current;
    private final @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized Message> messagesNotYetRead;
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Message> messagesToDelete;
    private @UnknownKeyFor @NonNull @Initialized Instant oldestPendingTimestamp = BoundedWindow.TIMESTAMP_MIN_VALUE;

    public SqsUnboundedReader(@UnknownKeyFor @NonNull @Initialized SqsUnboundedSource source, @UnknownKeyFor @NonNull @Initialized SqsCheckpointMark sqsCheckpointMark) {
        this.source = source;
        this.current = null;
        this.messagesNotYetRead = new ArrayDeque<Message>();
        this.messagesToDelete = new ArrayList<Message>();
        if (sqsCheckpointMark != null) {
            this.messagesToDelete.addAll(sqsCheckpointMark.getMessagesToDelete());
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        return this.oldestPendingTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized SqsMessage getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.getTimestamp(this.current.getTimeStamp());
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrentRecordId() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current.getMessageId().getBytes(StandardCharsets.UTF_8);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
        return new SqsCheckpointMark(this, this.messagesToDelete);
    }

    public @UnknownKeyFor @NonNull @Initialized SqsUnboundedSource getCurrentSource() {
        return this.source;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean start() {
        return this.advance();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean advance() {
        Message orgMsg;
        if (this.messagesNotYetRead.isEmpty()) {
            this.pull();
        }
        if ((orgMsg = this.messagesNotYetRead.poll()) == null) {
            return false;
        }
        String timeStamp = (String)orgMsg.attributes().get(MessageSystemAttributeName.APPROXIMATE_FIRST_RECEIVE_TIMESTAMP);
        this.current = SqsMessage.create(orgMsg.body(), orgMsg.messageId(), timeStamp);
        this.messagesToDelete.add(orgMsg);
        Instant currentMessageTimestamp = this.getCurrentTimestamp();
        if (this.getCurrentTimestamp().isBefore((ReadableInstant)this.oldestPendingTimestamp)) {
            this.oldestPendingTimestamp = currentMessageTimestamp;
        }
        return true;
    }

    public void close() {
    }

    void delete(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Message> messages) {
        for (Message message : messages) {
            if (!this.messagesToDelete.contains(message)) continue;
            DeleteMessageRequest deleteMessageRequest = (DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(this.source.getRead().queueUrl()).receiptHandle(message.receiptHandle()).build();
            this.source.getSqs().deleteMessage(deleteMessageRequest);
            Instant currentMessageTimestamp = this.getTimestamp((String)message.attributes().get(MessageSystemAttributeName.APPROXIMATE_FIRST_RECEIVE_TIMESTAMP));
            if (!currentMessageTimestamp.isAfter((ReadableInstant)this.oldestPendingTimestamp)) continue;
            this.oldestPendingTimestamp = currentMessageTimestamp;
        }
    }

    private void pull() {
        ReceiveMessageRequest receiveMessageRequest = (ReceiveMessageRequest)ReceiveMessageRequest.builder().maxNumberOfMessages(Integer.valueOf(10)).attributeNamesWithStrings(new String[]{MessageSystemAttributeName.APPROXIMATE_FIRST_RECEIVE_TIMESTAMP.toString()}).queueUrl(this.source.getRead().queueUrl()).build();
        ReceiveMessageResponse receiveMessageResponse = this.source.getSqs().receiveMessage(receiveMessageRequest);
        List messages = receiveMessageResponse.messages();
        if (messages == null || messages.isEmpty()) {
            return;
        }
        this.messagesNotYetRead.addAll(messages);
    }

    private @UnknownKeyFor @NonNull @Initialized Instant getTimestamp(@UnknownKeyFor @NonNull @Initialized String timeStamp) {
        return new Instant(Long.parseLong(timeStamp));
    }
}

