/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import com.google.auto.value.AutoValue;
import java.net.URI;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.sqs.AutoValue_SqsIO_Read;
import org.apache.beam.sdk.io.aws2.sqs.AutoValue_SqsIO_Write;
import org.apache.beam.sdk.io.aws2.sqs.BasicSqsClientProvider;
import org.apache.beam.sdk.io.aws2.sqs.SqsClientProvider;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SqsIO {
    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_SqsIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_SqsIO_Write.Builder().build();
    }

    private SqsIO() {
    }

    private static class SqsWriteFn
    extends DoFn<SendMessageRequest, Void> {
        private final @UnknownKeyFor @NonNull @Initialized Write spec;
        private transient @UnknownKeyFor @NonNull @Initialized SqsClient sqs;

        SqsWriteFn(@UnknownKeyFor @NonNull @Initialized Write write) {
            this.spec = write;
        }

        @DoFn.Setup
        public void setup() {
            this.sqs = this.spec.getSqsClientProvider().getSqsClient();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.sqs.sendMessage((SendMessageRequest)processContext.element());
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<SendMessageRequest>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized SqsClientProvider getSqsClientProvider();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Write withSqsClientProvider(@UnknownKeyFor @NonNull @Initialized SqsClientProvider awsClientsProvider) {
            return this.builder().setSqsClientProvider(awsClientsProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withSqsClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized String region) {
            return this.withSqsClientProvider(credentialsProvider, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withSqsClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized String region, @UnknownKeyFor @NonNull @Initialized URI serviceEndpoint) {
            return this.withSqsClientProvider(new BasicSqsClientProvider(credentialsProvider, region, serviceEndpoint));
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SendMessageRequest> input) {
            input.apply((PTransform)ParDo.of((DoFn)new SqsWriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSqsClientProvider(@UnknownKeyFor @NonNull @Initialized SqsClientProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<SqsMessage>> {
        abstract @Nullable @UnknownKeyFor @Initialized String queueUrl();

        abstract @UnknownKeyFor @NonNull @Initialized long maxNumRecords();

        abstract @Nullable @UnknownKeyFor @Initialized Duration maxReadTime();

        abstract @Nullable @UnknownKeyFor @Initialized SqsClientProvider sqsClientProvider();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Read withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
            return this.builder().setMaxNumRecords(maxNumRecords).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
            return this.builder().setMaxReadTime(maxReadTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQueueUrl(@UnknownKeyFor @NonNull @Initialized String queueUrl) {
            Preconditions.checkArgument((queueUrl != null ? 1 : 0) != 0, (Object)"queueUrl can not be null");
            Preconditions.checkArgument((!queueUrl.isEmpty() ? 1 : 0) != 0, (Object)"queueUrl can not be empty");
            return this.builder().setQueueUrl(queueUrl).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withSqsClientProvider(@UnknownKeyFor @NonNull @Initialized SqsClientProvider awsClientsProvider) {
            return this.builder().setSqsClientProvider(awsClientsProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withSqsClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized String region) {
            return this.withSqsClientProvider(credentialsProvider, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Read withSqsClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized String region, @UnknownKeyFor @NonNull @Initialized URI serviceEndpoint) {
            return this.withSqsClientProvider(new BasicSqsClientProvider(credentialsProvider, region, serviceEndpoint));
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SqsMessage> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Read.Unbounded unbounded;
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new SqsUnboundedSource(this));
            if (this.maxNumRecords() < Long.MAX_VALUE || this.maxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.maxReadTime()).withMaxNumRecords(this.maxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQueueUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSqsClientProvider(@UnknownKeyFor @NonNull @Initialized SqsClientProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

