/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedReader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import software.amazon.awssdk.services.sqs.model.Message;

class SqsCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Message> messagesToDelete;
    private final transient @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SqsUnboundedReader> reader;

    SqsCheckpointMark(@UnknownKeyFor @NonNull @Initialized SqsUnboundedReader reader, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Message> messagesToDelete) {
        this.reader = Optional.of(reader);
        this.messagesToDelete = ImmutableList.copyOf(messagesToDelete);
    }

    public void finalizeCheckpoint() {
        this.reader.ifPresent(r -> r.delete(this.messagesToDelete));
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Message> getMessagesToDelete() {
        return this.messagesToDelete;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqsCheckpointMark that = (SqsCheckpointMark)o;
        return Objects.equal(this.messagesToDelete, that.messagesToDelete);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.messagesToDelete});
    }
}

