/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class SendMessageRequestCoder
extends AtomicCoder<SendMessageRequest>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized SendMessageRequestCoder INSTANCE = new SendMessageRequestCoder();

    private SendMessageRequestCoder() {
    }

    static @UnknownKeyFor @NonNull @Initialized SendMessageRequestCoder of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized SendMessageRequest value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        StringUtf8Coder.of().encode(value.queueUrl(), outStream);
        StringUtf8Coder.of().encode(value.messageBody(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized SendMessageRequest decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String queueUrl = StringUtf8Coder.of().decode(inStream);
        String message = StringUtf8Coder.of().decode(inStream);
        return (SendMessageRequest)SendMessageRequest.builder().queueUrl(queueUrl).messageBody(message).build();
    }
}

