/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.services.sqs.model.Message;

public class MessageCoder
extends AtomicCoder<Message>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized MessageCoder INSTANCE = new MessageCoder();

    private MessageCoder() {
    }

    static @UnknownKeyFor @NonNull @Initialized MessageCoder of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized Message value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        StringUtf8Coder.of().encode(value.messageId(), outStream);
        StringUtf8Coder.of().encode(value.body(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized Message decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String messageId = StringUtf8Coder.of().decode(inStream);
        String body = StringUtf8Coder.of().decode(inStream);
        return (Message)Message.builder().messageId(messageId).body(body).build();
    }
}

