/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.net.URI;
import java.util.Objects;
import org.apache.beam.sdk.io.aws2.options.AwsSerializableUtils;
import org.apache.beam.sdk.io.aws2.sqs.SqsClientProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

class BasicSqsClientProvider
implements SqsClientProvider {
    private final @UnknownKeyFor @NonNull @Initialized String awsCredentialsProviderSerialized;
    private final @UnknownKeyFor @NonNull @Initialized String region;
    private final @Nullable @UnknownKeyFor @Initialized URI serviceEndpoint;

    BasicSqsClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider awsCredentialsProvider, @UnknownKeyFor @NonNull @Initialized String region, @Nullable @UnknownKeyFor @Initialized URI serviceEndpoint) {
        Preconditions.checkArgument((awsCredentialsProvider != null ? 1 : 0) != 0, (Object)"awsCredentialsProvider can not be null");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"region can not be null");
        this.awsCredentialsProviderSerialized = AwsSerializableUtils.serializeAwsCredentialsProvider(awsCredentialsProvider);
        Preconditions.checkNotNull((Object)this.awsCredentialsProviderSerialized, (Object)"awsCredentialsProviderString can not be null");
        this.region = region;
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SqsClient getSqsClient() {
        SqsClientBuilder builder = (SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().credentialsProvider(AwsSerializableUtils.deserializeAwsCredentialsProvider(this.awsCredentialsProviderSerialized))).region(Region.of((String)this.region));
        if (this.serviceEndpoint != null) {
            builder.endpointOverride(this.serviceEndpoint);
        }
        return (SqsClient)builder.build();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicSqsClientProvider that = (BasicSqsClientProvider)o;
        return Objects.equals(this.awsCredentialsProviderSerialized, that.awsCredentialsProviderSerialized) && Objects.equals(this.region, that.region) && Objects.equals(this.serviceEndpoint, that.serviceEndpoint);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.awsCredentialsProviderSerialized, this.region, this.serviceEndpoint);
    }
}

