/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.aws2.sns.SnsResponse;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SnsResponseCoder<@UnknownKeyFor T>
extends StructuredCoder<SnsResponse<T>> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder;
    private static final @UnknownKeyFor @NonNull @Initialized VarIntCoder STATUS_CODE_CODER = VarIntCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STATUS_TEXT_CODER = StringUtf8Coder.of();

    public SnsResponseCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder) {
        this.elementCoder = elementCoder;
    }

    static <T> @UnknownKeyFor @NonNull @Initialized SnsResponseCoder<T> of(@UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder) {
        return new SnsResponseCoder<T>(elementCoder);
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized SnsResponse<T> value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        T element = value.element();
        this.elementCoder.encode(element, outStream);
        OptionalInt statusCode = value.statusCode();
        if (statusCode.isPresent()) {
            BooleanCoder.of().encode(Boolean.TRUE, outStream);
            STATUS_CODE_CODER.encode(Integer.valueOf(statusCode.getAsInt()), outStream);
        } else {
            BooleanCoder.of().encode(Boolean.FALSE, outStream);
        }
        Optional<String> statusText = value.statusText();
        if (statusText.isPresent()) {
            BooleanCoder.of().encode(Boolean.TRUE, outStream);
            STATUS_TEXT_CODER.encode(statusText.get(), outStream);
        } else {
            BooleanCoder.of().encode(Boolean.FALSE, outStream);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized SnsResponse<T> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object element = this.elementCoder.decode(inStream);
        OptionalInt statusCode = OptionalInt.empty();
        if (BooleanCoder.of().decode(inStream).booleanValue()) {
            statusCode = OptionalInt.of(STATUS_CODE_CODER.decode(inStream));
        }
        Optional<String> statusText = Optional.empty();
        if (BooleanCoder.of().decode(inStream).booleanValue()) {
            statusText = Optional.of(STATUS_TEXT_CODER.decode(inStream));
        }
        return SnsResponse.create(element, statusCode, statusText);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return ImmutableList.of(this.elementCoder);
    }

    public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.elementCoder.verifyDeterministic();
    }
}

