/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.beam.sdk.io.aws2.sns.AutoValue_SnsResponse;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.services.sns.model.PublishResponse;

@AutoValue
abstract class SnsResponse<@UnknownKeyFor T>
implements Serializable {
    SnsResponse() {
    }

    public abstract T element();

    public abstract @UnknownKeyFor @NonNull @Initialized OptionalInt statusCode();

    public abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> statusText();

    static <T> @UnknownKeyFor @NonNull @Initialized SnsResponse<T> create(@NonNull T element, @UnknownKeyFor @NonNull @Initialized OptionalInt statusCode, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> statusText) {
        return new AutoValue_SnsResponse<T>(element, statusCode, statusText);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SnsResponse<T> of(@NonNull T element, @Nullable @UnknownKeyFor @Initialized PublishResponse response) {
        Optional<PublishResponse> publishResponse = Optional.ofNullable(response);
        OptionalInt statusCode = publishResponse.map(r -> OptionalInt.of(r.sdkHttpResponse().statusCode())).orElse(OptionalInt.empty());
        Optional<String> statusText = publishResponse.flatMap(r -> r.sdkHttpResponse().statusText());
        return SnsResponse.create(element, statusCode, statusText);
    }
}

