/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public class PublishResponseCoder
extends AtomicCoder<PublishResponse>
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized PublishResponseCoder INSTANCE = new PublishResponseCoder();

    private PublishResponseCoder() {
    }

    static @UnknownKeyFor @NonNull @Initialized PublishResponseCoder of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized PublishResponse value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        StringUtf8Coder.of().encode(value.messageId(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized PublishResponse decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String messageId = StringUtf8Coder.of().decode(inStream);
        return (PublishResponse)PublishResponse.builder().messageId(messageId).build();
    }
}

