/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.beam.sdk.io.aws2.options.AwsModule;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class AwsSerializableUtils {
    public static @UnknownKeyFor @NonNull @Initialized String serializeAwsCredentialsProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider awsCredentialsProvider) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return om.writeValueAsString((Object)awsCredentialsProvider);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("AwsCredentialsProvider can not be serialized to Json", e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider deserializeAwsCredentialsProvider(@UnknownKeyFor @NonNull @Initialized String awsCredentialsProviderSerialized) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return (AwsCredentialsProvider)om.readValue(awsCredentialsProviderSerialized, AwsCredentialsProvider.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AwsCredentialsProvider can not be deserialized from Json", e);
        }
    }
}

