/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.utils.AttributeMap;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class AwsModule
extends SimpleModule {
    private static final @UnknownKeyFor @NonNull @Initialized String ACCESS_KEY_ID = "accessKeyId";
    private static final @UnknownKeyFor @NonNull @Initialized String SECRET_ACCESS_KEY = "secretAccessKey";
    public static final @UnknownKeyFor @NonNull @Initialized String CONNECTION_ACQUIRE_TIMEOUT = "connectionAcquisitionTimeout";
    public static final @UnknownKeyFor @NonNull @Initialized String CONNECTION_MAX_IDLE_TIMEOUT = "connectionMaxIdleTime";
    public static final @UnknownKeyFor @NonNull @Initialized String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final @UnknownKeyFor @NonNull @Initialized String CONNECTION_TIME_TO_LIVE = "connectionTimeToLive";
    public static final @UnknownKeyFor @NonNull @Initialized String MAX_CONNECTIONS = "maxConnections";
    public static final @UnknownKeyFor @NonNull @Initialized String READ_TIMEOUT = "socketTimeout";

    public AwsModule() {
        super("AwsModule");
        this.setMixInAnnotation(AwsCredentialsProvider.class, AwsCredentialsProviderMixin.class);
        this.setMixInAnnotation(ProxyConfiguration.class, ProxyConfigurationMixin.class);
        this.setMixInAnnotation(AttributeMap.class, AttributeMapMixin.class);
    }

    private static class AttributeMapSerializer
    extends JsonSerializer<AttributeMap> {
        private AttributeMapSerializer() {
        }

        public void serialize(@UnknownKeyFor @NonNull @Initialized AttributeMap attributeMap, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            jsonGenerator.writeStartObject();
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)) {
                jsonGenerator.writeStringField(AwsModule.CONNECTION_ACQUIRE_TIMEOUT, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)) {
                jsonGenerator.writeStringField(AwsModule.CONNECTION_MAX_IDLE_TIMEOUT, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)) {
                jsonGenerator.writeStringField(AwsModule.CONNECTION_TIMEOUT, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE)) {
                jsonGenerator.writeStringField(AwsModule.CONNECTION_TIME_TO_LIVE, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS)) {
                jsonGenerator.writeStringField(AwsModule.MAX_CONNECTIONS, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)) {
                jsonGenerator.writeStringField(AwsModule.READ_TIMEOUT, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)));
            }
            jsonGenerator.writeEndObject();
        }
    }

    private static class AttributeMapDeserializer
    extends JsonDeserializer<AttributeMap> {
        private AttributeMapDeserializer() {
        }

        public @UnknownKeyFor @NonNull @Initialized AttributeMap deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Map map = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
            if (map.containsKey(AwsModule.CONNECTION_ACQUIRE_TIMEOUT)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT, (Object)Duration.parse((CharSequence)map.get(AwsModule.CONNECTION_ACQUIRE_TIMEOUT)));
            }
            if (map.containsKey(AwsModule.CONNECTION_MAX_IDLE_TIMEOUT)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)Duration.parse((CharSequence)map.get(AwsModule.CONNECTION_MAX_IDLE_TIMEOUT)));
            }
            if (map.containsKey(AwsModule.CONNECTION_TIMEOUT)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)Duration.parse((CharSequence)map.get(AwsModule.CONNECTION_TIMEOUT)));
            }
            if (map.containsKey(AwsModule.CONNECTION_TIME_TO_LIVE)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE, (Object)Duration.parse((CharSequence)map.get(AwsModule.CONNECTION_TIME_TO_LIVE)));
            }
            if (map.containsKey(AwsModule.MAX_CONNECTIONS)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)Integer.parseInt((String)map.get(AwsModule.MAX_CONNECTIONS)));
            }
            if (map.containsKey(AwsModule.READ_TIMEOUT)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)Duration.parse((CharSequence)map.get(AwsModule.READ_TIMEOUT)));
            }
            return attributeMapBuilder.build();
        }
    }

    @JsonSerialize(using=AttributeMapSerializer.class)
    @JsonDeserialize(using=AttributeMapDeserializer.class)
    private static class AttributeMapMixin {
        private AttributeMapMixin() {
        }
    }

    private static class ProxyConfigurationSerializer
    extends JsonSerializer<ProxyConfiguration> {
        private ProxyConfigurationSerializer() {
        }

        public void serialize(@UnknownKeyFor @NonNull @Initialized ProxyConfiguration proxyConfiguration, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String endpoint = proxyConfiguration.scheme() + "://" + proxyConfiguration.host() + ":" + proxyConfiguration.port();
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("endpoint", endpoint);
            jsonGenerator.writeStringField("username", proxyConfiguration.username());
            jsonGenerator.writeStringField("password", proxyConfiguration.password());
            jsonGenerator.writeEndObject();
        }
    }

    private static class ProxyConfigurationDeserializer
    extends JsonDeserializer<ProxyConfiguration> {
        private ProxyConfigurationDeserializer() {
        }

        public @UnknownKeyFor @NonNull @Initialized ProxyConfiguration deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Map asMap = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            return (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create((String)asMap.get("endpoint"))).username((String)asMap.get("username")).password((String)asMap.get("password")).useSystemPropertyValues(Boolean.valueOf((String)asMap.get("useSystemPropertyValues"))).build();
        }
    }

    @JsonDeserialize(using=ProxyConfigurationDeserializer.class)
    @JsonSerialize(using=ProxyConfigurationSerializer.class)
    private static class ProxyConfigurationMixin {
        private ProxyConfigurationMixin() {
        }
    }

    private static class AWSCredentialsProviderSerializer
    extends JsonSerializer<AwsCredentialsProvider> {
        private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Object> SINGLETON_CREDENTIAL_PROVIDERS = ImmutableSet.of(DefaultCredentialsProvider.class, EnvironmentVariableCredentialsProvider.class, SystemPropertyCredentialsProvider.class, ProfileCredentialsProvider.class, ContainerCredentialsProvider.class);

        private AWSCredentialsProviderSerializer() {
        }

        public void serialize(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            serializer.defaultSerializeValue((Object)credentialsProvider, jsonGenerator);
        }

        public void serializeWithType(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized JsonGenerator jsonGenerator, @UnknownKeyFor @NonNull @Initialized SerializerProvider serializer, @UnknownKeyFor @NonNull @Initialized TypeSerializer typeSerializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            WritableTypeId typeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId((Object)credentialsProvider, JsonToken.START_OBJECT));
            if (credentialsProvider.getClass().equals(StaticCredentialsProvider.class)) {
                jsonGenerator.writeStringField(AwsModule.ACCESS_KEY_ID, credentialsProvider.resolveCredentials().accessKeyId());
                jsonGenerator.writeStringField(AwsModule.SECRET_ACCESS_KEY, credentialsProvider.resolveCredentials().secretAccessKey());
            } else if (!SINGLETON_CREDENTIAL_PROVIDERS.contains(credentialsProvider.getClass())) {
                throw new IllegalArgumentException("Unsupported AWS credentials provider type " + credentialsProvider.getClass());
            }
            typeSerializer.writeTypeSuffix(jsonGenerator, typeId);
        }
    }

    private static class AwsCredentialsProviderDeserializer
    extends JsonDeserializer<AwsCredentialsProvider> {
        private AwsCredentialsProviderDeserializer() {
        }

        public @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return (AwsCredentialsProvider)context.readValue(jsonParser, AwsCredentialsProvider.class);
        }

        public @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider deserializeWithType(@UnknownKeyFor @NonNull @Initialized JsonParser jsonParser, @UnknownKeyFor @NonNull @Initialized DeserializationContext context, @UnknownKeyFor @NonNull @Initialized TypeDeserializer typeDeserializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            String typeNameKey;
            Map asMap = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            String typeName = (String)asMap.get(typeNameKey = typeDeserializer.getPropertyName());
            if (typeName == null) {
                throw new IOException(String.format("AWS credentials provider type name key '%s' not found", typeNameKey));
            }
            if (typeName.equals(StaticCredentialsProvider.class.getSimpleName())) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)((String)asMap.get(AwsModule.ACCESS_KEY_ID)), (String)((String)asMap.get(AwsModule.SECRET_ACCESS_KEY))));
            }
            if (typeName.equals(DefaultCredentialsProvider.class.getSimpleName())) {
                return DefaultCredentialsProvider.create();
            }
            if (typeName.equals(EnvironmentVariableCredentialsProvider.class.getSimpleName())) {
                return EnvironmentVariableCredentialsProvider.create();
            }
            if (typeName.equals(SystemPropertyCredentialsProvider.class.getSimpleName())) {
                return SystemPropertyCredentialsProvider.create();
            }
            if (typeName.equals(ProfileCredentialsProvider.class.getSimpleName())) {
                return ProfileCredentialsProvider.create();
            }
            if (typeName.equals(ContainerCredentialsProvider.class.getSimpleName())) {
                return ContainerCredentialsProvider.builder().build();
            }
            throw new IOException(String.format("AWS credential provider type '%s' is not supported", typeName));
        }
    }

    @JsonDeserialize(using=AwsCredentialsProviderDeserializer.class)
    @JsonSerialize(using=AWSCredentialsProviderSerializer.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    private static class AwsCredentialsProviderMixin {
        private AwsCredentialsProviderMixin() {
        }
    }
}

