/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public interface RateLimitPolicyFactory
extends Serializable {
    public @UnknownKeyFor @NonNull @Initialized RateLimitPolicy getRateLimitPolicy();

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withoutLimiter() {
        return () -> new RateLimitPolicy(){};
    }

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withFixedDelay() {
        return DelayIntervalRateLimiter::new;
    }

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withFixedDelay(@UnknownKeyFor @NonNull @Initialized Duration delay) {
        return () -> new DelayIntervalRateLimiter(() -> delay);
    }

    public static @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory withDelay(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay) {
        return () -> new DelayIntervalRateLimiter(delay);
    }

    public static class DelayIntervalRateLimiter
    implements RateLimitPolicy {
        private static final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> DEFAULT_DELAY = () -> Duration.standardSeconds((long)1L);
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay;

        public DelayIntervalRateLimiter() {
            this(DEFAULT_DELAY);
        }

        public DelayIntervalRateLimiter(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay) {
            this.delay = delay;
        }

        @Override
        public void onSuccess(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisRecord> records) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            Thread.sleep(this.delay.get().getMillis());
        }
    }
}

