/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.aws2.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.aws2.kinesis.DynamicCheckpointGenerator;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReader;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecordCoder;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.StaticCheckpointGenerator;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KinesisSource
extends UnboundedSource<KinesisRecord, KinesisReaderCheckpoint> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KinesisSource.class);
    private final @UnknownKeyFor @NonNull @Initialized AWSClientsProvider awsClientsProvider;
    private final @UnknownKeyFor @NonNull @Initialized String streamName;
    private final @UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory;
    private final @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory;
    private @UnknownKeyFor @NonNull @Initialized CheckpointGenerator initialCheckpointGenerator;
    private final @UnknownKeyFor @NonNull @Initialized Integer limit;
    private final @UnknownKeyFor @NonNull @Initialized Integer maxCapacityPerShard;

    KinesisSource(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider awsClientsProvider, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint, @UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold, @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory, @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory, @UnknownKeyFor @NonNull @Initialized Integer limit, @UnknownKeyFor @NonNull @Initialized Integer maxCapacityPerShard) {
        this(awsClientsProvider, new DynamicCheckpointGenerator(streamName, startingPoint), streamName, upToDateThreshold, watermarkPolicyFactory, rateLimitPolicyFactory, limit, maxCapacityPerShard);
    }

    private KinesisSource(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider awsClientsProvider, @UnknownKeyFor @NonNull @Initialized CheckpointGenerator initialCheckpoint, @UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold, @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory, @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory, @UnknownKeyFor @NonNull @Initialized Integer limit, @UnknownKeyFor @NonNull @Initialized Integer maxCapacityPerShard) {
        this.awsClientsProvider = awsClientsProvider;
        this.initialCheckpointGenerator = initialCheckpoint;
        this.streamName = streamName;
        this.upToDateThreshold = upToDateThreshold;
        this.watermarkPolicyFactory = watermarkPolicyFactory;
        this.rateLimitPolicyFactory = rateLimitPolicyFactory;
        this.limit = limit;
        this.maxCapacityPerShard = maxCapacityPerShard;
        this.validate();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized KinesisSource> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
        KinesisReaderCheckpoint checkpoint = this.initialCheckpointGenerator.generate(SimplifiedKinesisClient.from(this.awsClientsProvider, this.limit));
        ArrayList sources = Lists.newArrayList();
        for (KinesisReaderCheckpoint partition : checkpoint.splitInto(desiredNumSplits)) {
            sources.add(new KinesisSource(this.awsClientsProvider, new StaticCheckpointGenerator(partition), this.streamName, this.upToDateThreshold, this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.limit, this.maxCapacityPerShard));
        }
        return sources;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized KinesisRecord> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint checkpointMark) {
        CheckpointGenerator checkpointGenerator = this.initialCheckpointGenerator;
        if (checkpointMark != null) {
            checkpointGenerator = new StaticCheckpointGenerator(checkpointMark);
        }
        LOG.info("Creating new reader using {}", (Object)checkpointGenerator);
        return new KinesisReader(SimplifiedKinesisClient.from(this.awsClientsProvider, this.limit), checkpointGenerator, this, this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.upToDateThreshold, this.maxCapacityPerShard);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint> getCheckpointMarkCoder() {
        return SerializableCoder.of(KinesisReaderCheckpoint.class);
    }

    public void validate() {
        Preconditions.checkNotNull((Object)this.awsClientsProvider);
        Preconditions.checkNotNull((Object)this.initialCheckpointGenerator);
        Preconditions.checkNotNull((Object)this.watermarkPolicyFactory);
        Preconditions.checkNotNull((Object)this.rateLimitPolicyFactory);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KinesisRecord> getOutputCoder() {
        return KinesisRecordCoder.of();
    }

    @UnknownKeyFor @NonNull @Initialized String getStreamName() {
        return this.streamName;
    }
}

