/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import com.google.auto.value.AutoValue;
import java.util.function.Supplier;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.aws2.kinesis.AutoValue_KinesisIO_Read;
import org.apache.beam.sdk.io.aws2.kinesis.BasicKinesisProvider;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisSource;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.kinesis.common.InitialPositionInStream;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public final class KinesisIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KinesisIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_NUM_RETRIES = 6;

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_KinesisIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).setUpToDateThreshold(Duration.ZERO).setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).setRateLimitPolicyFactory(RateLimitPolicyFactory.withoutLimiter()).setMaxCapacityPerShard(10000).build();
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<KinesisRecord>> {
        abstract @Nullable @UnknownKeyFor @Initialized String getStreamName();

        abstract @Nullable @UnknownKeyFor @Initialized StartingPoint getInitialPosition();

        abstract @Nullable @UnknownKeyFor @Initialized AWSClientsProvider getAWSClientsProvider();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumRecords();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getMaxReadTime();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getUpToDateThreshold();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getRequestRecordsLimit();

        abstract @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory getWatermarkPolicyFactory();

        abstract @UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory getRateLimitPolicyFactory();

        abstract @UnknownKeyFor @NonNull @Initialized Integer getMaxCapacityPerShard();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read withStreamName(@UnknownKeyFor @NonNull @Initialized String streamName) {
            return this.toBuilder().setStreamName(streamName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInitialPositionInStream(@UnknownKeyFor @NonNull @Initialized InitialPositionInStream initialPosition) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialPosition)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInitialTimestampInStream(@UnknownKeyFor @NonNull @Initialized Instant initialTimestamp) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialTimestamp)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider awsClientsProvider) {
            return this.toBuilder().setAWSClientsProvider(awsClientsProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Region region) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Read withAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized String awsAccessKey, @UnknownKeyFor @NonNull @Initialized String awsSecretKey, @UnknownKeyFor @NonNull @Initialized Region region, @UnknownKeyFor @NonNull @Initialized String serviceEndpoint) {
            return this.withAWSClientsProvider(new BasicKinesisProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
            Preconditions.checkArgument((maxNumRecords > 0L ? 1 : 0) != 0, (String)"maxNumRecords must be positive, but was: %s", (long)maxNumRecords);
            return this.toBuilder().setMaxNumRecords(maxNumRecords).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
            Preconditions.checkArgument((maxReadTime != null ? 1 : 0) != 0, (Object)"maxReadTime can not be null");
            return this.toBuilder().setMaxReadTime(maxReadTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withUpToDateThreshold(@UnknownKeyFor @NonNull @Initialized Duration upToDateThreshold) {
            Preconditions.checkArgument((upToDateThreshold != null ? 1 : 0) != 0, (Object)"upToDateThreshold can not be null");
            return this.toBuilder().setUpToDateThreshold(upToDateThreshold).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withRequestRecordsLimit(@UnknownKeyFor @NonNull @Initialized int limit) {
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (String)"limit must be positive, but was: %s", (int)limit);
            Preconditions.checkArgument((limit <= 10000 ? 1 : 0) != 0, (String)"limit must be up to 10,000, but was: %s", (int)limit);
            return this.toBuilder().setRequestRecordsLimit(limit).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withArrivalTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withArrivalTimeWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized Duration watermarkIdleDurationThreshold) {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy(watermarkIdleDurationThreshold)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProcessingTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withProcessingTimePolicy()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withCustomWatermarkPolicy(@UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory) {
            Preconditions.checkArgument((watermarkPolicyFactory != null ? 1 : 0) != 0, (Object)"watermarkPolicyFactory cannot be null");
            return this.toBuilder().setWatermarkPolicyFactory(watermarkPolicyFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withFixedDelayRateLimitPolicy() {
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withFixedDelayRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized Duration delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay(delay)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDynamicDelayRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Duration> delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withDelay(delay)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withCustomRateLimitPolicy(@UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory rateLimitPolicyFactory) {
            Preconditions.checkArgument((rateLimitPolicyFactory != null ? 1 : 0) != 0, (Object)"rateLimitPolicyFactory cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(rateLimitPolicyFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxCapacityPerShard(@UnknownKeyFor @NonNull @Initialized Integer maxCapacity) {
            Preconditions.checkArgument((maxCapacity > 0 ? 1 : 0) != 0, (String)"maxCapacity must be positive, but was: %s", (Object)maxCapacity);
            return this.toBuilder().setMaxCapacityPerShard(maxCapacity).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KinesisRecord> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Read.Unbounded unbounded;
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new KinesisSource(this.getAWSClientsProvider(), this.getStreamName(), this.getInitialPosition(), this.getUpToDateThreshold(), this.getWatermarkPolicyFactory(), this.getRateLimitPolicyFactory(), this.getRequestRecordsLimit(), this.getMaxCapacityPerShard()));
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return (PCollection)input.apply((PTransform)transform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setStreamName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInitialPosition(@UnknownKeyFor @NonNull @Initialized StartingPoint var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setAWSClientsProvider(@UnknownKeyFor @NonNull @Initialized AWSClientsProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setUpToDateThreshold(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRequestRecordsLimit(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWatermarkPolicyFactory(@UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRateLimitPolicyFactory(@UnknownKeyFor @NonNull @Initialized RateLimitPolicyFactory var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxCapacityPerShard(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

