/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.aws2.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPointShardsFinder;
import org.apache.beam.sdk.io.aws2.kinesis.TransientKinesisException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.model.Shard;

class DynamicCheckpointGenerator
implements CheckpointGenerator {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DynamicCheckpointGenerator.class);
    private final @UnknownKeyFor @NonNull @Initialized String streamName;
    private final @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint;
    private final @UnknownKeyFor @NonNull @Initialized StartingPointShardsFinder startingPointShardsFinder;

    public DynamicCheckpointGenerator(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint) {
        this.streamName = streamName;
        this.startingPoint = startingPoint;
        this.startingPointShardsFinder = new StartingPointShardsFinder();
    }

    public DynamicCheckpointGenerator(@UnknownKeyFor @NonNull @Initialized String streamName, @UnknownKeyFor @NonNull @Initialized StartingPoint startingPoint, @UnknownKeyFor @NonNull @Initialized StartingPointShardsFinder startingPointShardsFinder) {
        this.streamName = (String)Preconditions.checkNotNull((Object)streamName, (Object)"streamName");
        this.startingPoint = (StartingPoint)Preconditions.checkNotNull((Object)startingPoint, (Object)"startingPoint");
        this.startingPointShardsFinder = (StartingPointShardsFinder)Preconditions.checkNotNull((Object)startingPointShardsFinder, (Object)"startingPointShardsFinder");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint generate(@UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis) throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        Set<Shard> shardsAtStartingPoint = this.startingPointShardsFinder.findShardsAtStartingPoint(kinesis, this.streamName, this.startingPoint);
        LOG.info("Creating a checkpoint with following shards {} at {}", shardsAtStartingPoint, (Object)this.startingPoint.getTimestamp());
        return new KinesisReaderCheckpoint(shardsAtStartingPoint.stream().map(shard -> new ShardCheckpoint(this.streamName, shard.shardId(), this.startingPoint)).collect(Collectors.toList()));
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("Checkpoint generator for %s: %s", this.streamName, this.startingPoint);
    }
}

