/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.net.URI;
import org.apache.beam.sdk.io.aws2.kinesis.AWSClientsProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;

class BasicKinesisProvider
implements AWSClientsProvider {
    private final @UnknownKeyFor @NonNull @Initialized String accessKey;
    private final @UnknownKeyFor @NonNull @Initialized String secretKey;
    private final @UnknownKeyFor @NonNull @Initialized String region;
    private final @Nullable @UnknownKeyFor @Initialized String serviceEndpoint;

    BasicKinesisProvider(@UnknownKeyFor @NonNull @Initialized String accessKey, @UnknownKeyFor @NonNull @Initialized String secretKey, @UnknownKeyFor @NonNull @Initialized Region region, @Nullable @UnknownKeyFor @Initialized String serviceEndpoint) {
        Preconditions.checkArgument((accessKey != null ? 1 : 0) != 0, (Object)"accessKey can not be null");
        Preconditions.checkArgument((secretKey != null ? 1 : 0) != 0, (Object)"secretKey can not be null");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"region can not be null");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region.toString();
        this.serviceEndpoint = serviceEndpoint;
    }

    private @UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider getCredentialsProvider() {
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized KinesisClient getKinesisClient() {
        KinesisClientBuilder clientBuilder = (KinesisClientBuilder)((KinesisClientBuilder)KinesisClient.builder().credentialsProvider(this.getCredentialsProvider())).region(Region.of((String)this.region));
        if (this.serviceEndpoint != null) {
            clientBuilder.endpointOverride(URI.create(this.serviceEndpoint));
        }
        return (KinesisClient)clientBuilder.build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CloudWatchClient getCloudWatchClient() {
        CloudWatchClientBuilder clientBuilder = (CloudWatchClientBuilder)((CloudWatchClientBuilder)CloudWatchClient.builder().credentialsProvider(this.getCredentialsProvider())).region(Region.of((String)this.region));
        if (this.serviceEndpoint != null) {
            clientBuilder.endpointOverride(URI.create(this.serviceEndpoint));
        }
        return (CloudWatchClient)clientBuilder.build();
    }
}

