/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkParameters;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.joda.time.Duration;
import org.joda.time.Instant;

final class AutoValue_WatermarkParameters
extends WatermarkParameters {
    private final Instant currentWatermark;
    private final Instant eventTime;
    private final Instant lastUpdateTime;
    private final SerializableFunction<KinesisRecord, Instant> timestampFn;
    private final Duration watermarkIdleDurationThreshold;

    private AutoValue_WatermarkParameters(Instant currentWatermark, Instant eventTime, Instant lastUpdateTime, SerializableFunction<KinesisRecord, Instant> timestampFn, Duration watermarkIdleDurationThreshold) {
        this.currentWatermark = currentWatermark;
        this.eventTime = eventTime;
        this.lastUpdateTime = lastUpdateTime;
        this.timestampFn = timestampFn;
        this.watermarkIdleDurationThreshold = watermarkIdleDurationThreshold;
    }

    @Override
    Instant getCurrentWatermark() {
        return this.currentWatermark;
    }

    @Override
    Instant getEventTime() {
        return this.eventTime;
    }

    @Override
    Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    SerializableFunction<KinesisRecord, Instant> getTimestampFn() {
        return this.timestampFn;
    }

    @Override
    Duration getWatermarkIdleDurationThreshold() {
        return this.watermarkIdleDurationThreshold;
    }

    public String toString() {
        return "WatermarkParameters{currentWatermark=" + this.currentWatermark + ", eventTime=" + this.eventTime + ", lastUpdateTime=" + this.lastUpdateTime + ", timestampFn=" + this.timestampFn + ", watermarkIdleDurationThreshold=" + this.watermarkIdleDurationThreshold + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WatermarkParameters) {
            WatermarkParameters that = (WatermarkParameters)o;
            return this.currentWatermark.equals((Object)that.getCurrentWatermark()) && this.eventTime.equals((Object)that.getEventTime()) && this.lastUpdateTime.equals((Object)that.getLastUpdateTime()) && this.timestampFn.equals(that.getTimestampFn()) && this.watermarkIdleDurationThreshold.equals((Object)that.getWatermarkIdleDurationThreshold());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.currentWatermark.hashCode();
        h$ *= 1000003;
        h$ ^= this.eventTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.lastUpdateTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.timestampFn.hashCode();
        h$ *= 1000003;
        return h$ ^= this.watermarkIdleDurationThreshold.hashCode();
    }

    @Override
    public WatermarkParameters.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends WatermarkParameters.Builder {
        private Instant currentWatermark;
        private Instant eventTime;
        private Instant lastUpdateTime;
        private SerializableFunction<KinesisRecord, Instant> timestampFn;
        private Duration watermarkIdleDurationThreshold;

        Builder() {
        }

        private Builder(WatermarkParameters source) {
            this.currentWatermark = source.getCurrentWatermark();
            this.eventTime = source.getEventTime();
            this.lastUpdateTime = source.getLastUpdateTime();
            this.timestampFn = source.getTimestampFn();
            this.watermarkIdleDurationThreshold = source.getWatermarkIdleDurationThreshold();
        }

        @Override
        WatermarkParameters.Builder setCurrentWatermark(Instant currentWatermark) {
            if (currentWatermark == null) {
                throw new NullPointerException("Null currentWatermark");
            }
            this.currentWatermark = currentWatermark;
            return this;
        }

        @Override
        WatermarkParameters.Builder setEventTime(Instant eventTime) {
            if (eventTime == null) {
                throw new NullPointerException("Null eventTime");
            }
            this.eventTime = eventTime;
            return this;
        }

        @Override
        WatermarkParameters.Builder setLastUpdateTime(Instant lastUpdateTime) {
            if (lastUpdateTime == null) {
                throw new NullPointerException("Null lastUpdateTime");
            }
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        WatermarkParameters.Builder setTimestampFn(SerializableFunction<KinesisRecord, Instant> timestampFn) {
            if (timestampFn == null) {
                throw new NullPointerException("Null timestampFn");
            }
            this.timestampFn = timestampFn;
            return this;
        }

        @Override
        WatermarkParameters.Builder setWatermarkIdleDurationThreshold(Duration watermarkIdleDurationThreshold) {
            if (watermarkIdleDurationThreshold == null) {
                throw new NullPointerException("Null watermarkIdleDurationThreshold");
            }
            this.watermarkIdleDurationThreshold = watermarkIdleDurationThreshold;
            return this;
        }

        @Override
        WatermarkParameters build() {
            String missing = "";
            if (this.currentWatermark == null) {
                missing = missing + " currentWatermark";
            }
            if (this.eventTime == null) {
                missing = missing + " eventTime";
            }
            if (this.lastUpdateTime == null) {
                missing = missing + " lastUpdateTime";
            }
            if (this.timestampFn == null) {
                missing = missing + " timestampFn";
            }
            if (this.watermarkIdleDurationThreshold == null) {
                missing = missing + " watermarkIdleDurationThreshold";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_WatermarkParameters(this.currentWatermark, this.eventTime, this.lastUpdateTime, this.timestampFn, this.watermarkIdleDurationThreshold);
        }
    }
}

