/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.aws2.dynamodb.AttributeValueCoder;
import org.apache.beam.sdk.io.aws2.dynamodb.AutoValue_DynamoDBIO_Read;
import org.apache.beam.sdk.io.aws2.dynamodb.AutoValue_DynamoDBIO_RetryConfiguration;
import org.apache.beam.sdk.io.aws2.dynamodb.AutoValue_DynamoDBIO_Write;
import org.apache.beam.sdk.io.aws2.dynamodb.BasicDynamoDbClientProvider;
import org.apache.beam.sdk.io.aws2.dynamodb.DynamoDbClientProvider;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public final class DynamoDBIO {
    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read() {
        return new AutoValue_DynamoDBIO_Read.Builder().build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_DynamoDBIO_Write.Builder().setDeduplicateKeys(new ArrayList<String>()).build();
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Void>> {
        abstract @Nullable @UnknownKeyFor @Initialized DynamoDbClientProvider getDynamoDbClientProvider();

        abstract @Nullable @UnknownKeyFor @Initialized RetryConfiguration getRetryConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> getWriteItemMapperFn();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDeduplicateKeys();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDynamoDbClientProvider(@UnknownKeyFor @NonNull @Initialized DynamoDbClientProvider dynamoDbClientProvider) {
            return this.toBuilder().setDynamoDbClientProvider(dynamoDbClientProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDynamoDbClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized String region, @UnknownKeyFor @NonNull @Initialized URI serviceEndpoint) {
            return this.withDynamoDbClientProvider(new BasicDynamoDbClientProvider(credentialsProvider, region, serviceEndpoint));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDynamoDbClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized String region) {
            return this.withDynamoDbClientProvider(credentialsProvider, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration retryConfiguration) {
            Preconditions.checkArgument((retryConfiguration != null ? 1 : 0) != 0, (Object)"retryConfiguration is required");
            return this.toBuilder().setRetryConfiguration(retryConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWriteRequestMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> writeItemMapperFn) {
            return this.toBuilder().setWriteItemMapperFn(writeItemMapperFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDeduplicateKeys(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> deduplicateKeys) {
            return this.toBuilder().setDeduplicateKeys(deduplicateKeys).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @Nullable @Initialized Void> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            return (PCollection)input.apply((PTransform)ParDo.of(new WriteFn(this)));
        }

        static class WriteFn<@UnknownKeyFor T>
        extends DoFn<T, Void> {
            @VisibleForTesting
            static final @UnknownKeyFor @NonNull @Initialized String RETRY_ATTEMPT_LOG = "Error writing to DynamoDB. Retry attempt[%d]";
            private static final @UnknownKeyFor @NonNull @Initialized Duration RETRY_INITIAL_BACKOFF = Duration.standardSeconds((long)5L);
            private transient @UnknownKeyFor @NonNull @Initialized FluentBackoff retryBackoff;
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteFn.class);
            private static final @UnknownKeyFor @NonNull @Initialized Counter DYNAMO_DB_WRITE_FAILURES = Metrics.counter(WriteFn.class, (String)"DynamoDB_Write_Failures");
            private static final @UnknownKeyFor @NonNull @Initialized int BATCH_SIZE = 25;
            private transient @UnknownKeyFor @NonNull @Initialized DynamoDbClient client;
            private final @UnknownKeyFor @NonNull @Initialized Write spec;
            private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> batch;

            WriteFn(@UnknownKeyFor @NonNull @Initialized Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() {
                this.client = this.spec.getDynamoDbClientProvider().getDynamoDbClient();
                this.retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(0).withInitialBackoff(RETRY_INITIAL_BACKOFF);
                if (this.spec.getRetryConfiguration() != null) {
                    this.retryBackoff = this.retryBackoff.withMaxRetries(this.spec.getRetryConfiguration().getMaxAttempts() - 1).withMaxCumulativeBackoff(this.spec.getRetryConfiguration().getMaxDuration());
                }
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext context) {
                this.batch = new HashMap<KV<String, Map<String, AttributeValue>>, KV<String, WriteRequest>>();
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                KV writeRequest = (KV)this.spec.getWriteItemMapperFn().apply(context.element());
                this.batch.put((KV<String, Map<String, AttributeValue>>)KV.of((Object)((String)writeRequest.getKey()), this.extractDeduplicateKeyValues((WriteRequest)writeRequest.getValue())), (KV<String, WriteRequest>)writeRequest);
                if (this.batch.size() >= 25) {
                    this.flushBatch();
                }
            }

            private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue> extractDeduplicateKeyValues(@UnknownKeyFor @NonNull @Initialized WriteRequest request) {
                if (request.putRequest() != null) {
                    return request.putRequest().item().entrySet().stream().filter(entry -> this.spec.getDeduplicateKeys().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                }
                if (request.deleteRequest() != null) {
                    return request.deleteRequest().key().entrySet().stream().filter(entry -> this.spec.getDeduplicateKeys().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                }
                return Collections.emptyMap();
            }

            @DoFn.FinishBundle
            public void finishBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.flushBatch();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void flushBatch() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                if (this.batch.isEmpty()) {
                    return;
                }
                try {
                    Map mapTableRequest = this.batch.values().stream().collect(Collectors.groupingBy(KV::getKey, Collectors.mapping(KV::getValue, Collectors.toList())));
                    BatchWriteItemRequest batchRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(mapTableRequest).build();
                    Sleeper sleeper = Sleeper.DEFAULT;
                    BackOff backoff = this.retryBackoff.backoff();
                    int attempt = 0;
                    while (true) {
                        ++attempt;
                        try {
                            this.client.batchWriteItem(batchRequest);
                        }
                        catch (Exception ex) {
                            if (this.spec.getRetryConfiguration() == null || !this.spec.getRetryConfiguration().getRetryPredicate().test(ex)) {
                                DYNAMO_DB_WRITE_FAILURES.inc();
                                LOG.info("Unable to write batch items {}.", batchRequest.requestItems().entrySet(), (Object)ex);
                                throw new IOException("Error writing to DynamoDB (no attempt made to retry)", ex);
                            }
                            if (!BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) {
                                throw new IOException(String.format("Error writing to DynamoDB after %d attempt(s). No more attempts allowed", attempt), ex);
                            }
                            LOG.warn(String.format(RETRY_ATTEMPT_LOG, attempt), (Throwable)ex);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.batch.clear();
                }
            }

            @DoFn.Teardown
            public void tearDown() {
                if (this.client != null) {
                    this.client.close();
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDynamoDbClientProvider(@UnknownKeyFor @NonNull @Initialized DynamoDbClientProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRetryConfiguration(@UnknownKeyFor @NonNull @Initialized RetryConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteItemMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDeduplicateKeys(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }

    @AutoValue
    public static abstract class RetryConfiguration
    implements Serializable {
        @VisibleForTesting
        static final @UnknownKeyFor @NonNull @Initialized RetryPredicate DEFAULT_RETRY_PREDICATE = new DefaultRetryPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized int getMaxAttempts();

        abstract @UnknownKeyFor @NonNull @Initialized Duration getMaxDuration();

        abstract @UnknownKeyFor @NonNull @Initialized RetryPredicate getRetryPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_DynamoDBIO_RetryConfiguration.Builder().setRetryPredicate(DEFAULT_RETRY_PREDICATE);
        }

        private static class DefaultRetryPredicate
        implements RetryPredicate {
            private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Integer> ELIGIBLE_CODES = ImmutableSet.of((Object)503);

            private DefaultRetryPredicate() {
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean test(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
                return throwable instanceof IOException || throwable instanceof DynamoDbException || throwable instanceof DynamoDbException && ELIGIBLE_CODES.contains((Object)((DynamoDbException)throwable).statusCode());
            }
        }

        @FunctionalInterface
        static interface RetryPredicate
        extends Predicate<Throwable>,
        Serializable {
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxAttempts(@UnknownKeyFor @NonNull @Initialized int var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxDuration(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRetryPredicate(@UnknownKeyFor @NonNull @Initialized RetryPredicate var1);

            abstract @UnknownKeyFor @NonNull @Initialized RetryConfiguration autoBuild();

            public @UnknownKeyFor @NonNull @Initialized RetryConfiguration build() {
                RetryConfiguration configuration = this.autoBuild();
                Preconditions.checkArgument((configuration.getMaxAttempts() > 0 ? 1 : 0) != 0, (Object)"maxAttempts should be greater than 0");
                Preconditions.checkArgument((configuration.getMaxDuration() != null && configuration.getMaxDuration().isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"maxDuration should be greater than 0");
                return configuration;
            }
        }
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @Nullable @UnknownKeyFor @Initialized DynamoDbClientProvider getDynamoDbClientProvider();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> getScanRequestFn();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getSegmentId();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResponse, T> getScanResponseMapperFn();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> withDynamoDbClientProvider(@UnknownKeyFor @NonNull @Initialized DynamoDbClientProvider dynamoDbClientProvider) {
            return this.toBuilder().setDynamoDbClientProvider(dynamoDbClientProvider).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withDynamoDbClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized String region, @UnknownKeyFor @NonNull @Initialized URI serviceEndpoint) {
            return this.withDynamoDbClientProvider(new BasicDynamoDbClientProvider(credentialsProvider, region, serviceEndpoint));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withDynamoDbClientProvider(@UnknownKeyFor @NonNull @Initialized AwsCredentialsProvider credentialsProvider, @UnknownKeyFor @NonNull @Initialized String region) {
            return this.withDynamoDbClientProvider(credentialsProvider, region, null);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withScanRequestFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> fn) {
            return this.toBuilder().setScanRequestFn(fn).build();
        }

        private @UnknownKeyFor @NonNull @Initialized Read<T> withSegmentId(@UnknownKeyFor @NonNull @Initialized Integer segmentId) {
            Preconditions.checkArgument((segmentId != null ? 1 : 0) != 0, (Object)"segmentId can not be null");
            return this.toBuilder().setSegmentId(segmentId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withScanResponseMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResponse, T> scanResultMapperFn) {
            Preconditions.checkArgument((scanResultMapperFn != null ? 1 : 0) != 0, (Object)"scanResultMapper can not be null");
            return this.toBuilder().setScanResponseMapperFn(scanResultMapperFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>>> items() {
            return this.withScanResponseMapperFn(new ItemsMapper()).withCoder((Coder<List<Map<String, AttributeValue>>>)ListCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)AttributeValueCoder.of())));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.getScanRequestFn() != null ? 1 : 0) != 0, (Object)"withScanRequestFn() is required");
            Preconditions.checkArgument((this.getDynamoDbClientProvider() != null ? 1 : 0) != 0, (Object)"withDynamoDbClientProvider() is required");
            ScanRequest scanRequest = (ScanRequest)this.getScanRequestFn().apply(null);
            Preconditions.checkArgument((scanRequest.totalSegments() != null && scanRequest.totalSegments() > 0 ? 1 : 0) != 0, (Object)"TotalSegments is required with withScanRequestFn() and greater zero");
            PCollection splits = (PCollection)((PCollection)input.apply("Create", (PTransform)Create.of((Object)((Object)this), (Object[])new Read[0]))).apply("Split", (PTransform)ParDo.of(new SplitFn()));
            splits.setCoder((Coder)SerializableCoder.of((TypeDescriptor)new TypeDescriptor<Read<T>>(){}));
            PCollection output = (PCollection)((PCollection)splits.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read", (PTransform)ParDo.of(new ReadFn()));
            output.setCoder(this.getCoder());
            return output;
        }

        static final class ItemsMapper<@UnknownKeyFor T>
        implements SerializableFunction<ScanResponse, List<Map<String, AttributeValue>>> {
            ItemsMapper() {
            }

            public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>> apply(@Nullable @UnknownKeyFor @Initialized ScanResponse scanResponse) {
                if (scanResponse == null) {
                    return Collections.emptyList();
                }
                return scanResponse.items();
            }
        }

        private static class ReadFn<@UnknownKeyFor T>
        extends DoFn<Read<T>, T> {
            private ReadFn() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Read<T> spec, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> out) {
                DynamoDbClient client = spec.getDynamoDbClientProvider().getDynamoDbClient();
                ScanRequest scanRequest = (ScanRequest)spec.getScanRequestFn().apply(null);
                ScanRequest scanRequestWithSegment = (ScanRequest)scanRequest.toBuilder().segment(spec.getSegmentId()).build();
                ScanResponse scanResponse = client.scan(scanRequestWithSegment);
                out.output(spec.getScanResponseMapperFn().apply((Object)scanResponse));
            }
        }

        private static class SplitFn<@UnknownKeyFor T>
        extends DoFn<Read<T>, Read<T>> {
            private SplitFn() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Read<T> spec, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Read<T>> out) {
                ScanRequest scanRequest = (ScanRequest)spec.getScanRequestFn().apply(null);
                for (int i = 0; i < scanRequest.totalSegments(); ++i) {
                    out.output((Object)((Read)spec).withSegmentId(i));
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDynamoDbClientProvider(@UnknownKeyFor @NonNull @Initialized DynamoDbClientProvider var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setScanRequestFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSegmentId(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setScanResponseMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResponse, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }
}

