/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.sqs.SqsCheckpointMark;
import org.apache.beam.sdk.io.aws2.sqs.SqsIO;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedReader;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Suppliers;
import software.amazon.awssdk.services.sqs.SqsClient;

class SqsUnboundedSource
extends UnboundedSource<SqsMessage, SqsCheckpointMark> {
    private final SqsIO.Read read;
    private final Supplier<SqsClient> sqs;

    public SqsUnboundedSource(SqsIO.Read read) {
        this.read = read;
        this.sqs = Suppliers.memoize((Supplier & Serializable)() -> read.sqsClientProvider().getSqsClient());
    }

    public List<SqsUnboundedSource> split(int desiredNumSplits, PipelineOptions options) {
        ArrayList<SqsUnboundedSource> sources = new ArrayList<SqsUnboundedSource>();
        for (int i = 0; i < Math.max(1, desiredNumSplits); ++i) {
            sources.add(new SqsUnboundedSource(this.read));
        }
        return sources;
    }

    public UnboundedSource.UnboundedReader<SqsMessage> createReader(PipelineOptions options, @Nullable SqsCheckpointMark checkpointMark) {
        return new SqsUnboundedReader(this, checkpointMark);
    }

    public Coder<SqsCheckpointMark> getCheckpointMarkCoder() {
        return SerializableCoder.of(SqsCheckpointMark.class);
    }

    public Coder<SqsMessage> getOutputCoder() {
        return SerializableCoder.of(SqsMessage.class);
    }

    public SqsIO.Read getRead() {
        return this.read;
    }

    public SqsClient getSqs() {
        return (SqsClient)this.sqs.get();
    }

    public boolean requiresDeduping() {
        return true;
    }
}

