/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import com.google.auto.value.AutoValue;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.sqs.AutoValue_SqsIO_Read;
import org.apache.beam.sdk.io.aws2.sqs.AutoValue_SqsIO_Write;
import org.apache.beam.sdk.io.aws2.sqs.BasicSqsClientProvider;
import org.apache.beam.sdk.io.aws2.sqs.SqsClientProvider;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Duration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SqsIO {
    public static Read read() {
        return new AutoValue_SqsIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).build();
    }

    public static Write write() {
        return new AutoValue_SqsIO_Write.Builder().build();
    }

    private SqsIO() {
    }

    private static class SqsWriteFn
    extends DoFn<SendMessageRequest, Void> {
        private final Write spec;
        private transient SqsClient sqs;

        SqsWriteFn(Write write) {
            this.spec = write;
        }

        @DoFn.Setup
        public void setup() {
            this.sqs = this.spec.getSqsClientProvider().getSqsClient();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext processContext) throws Exception {
            this.sqs.sendMessage((SendMessageRequest)processContext.element());
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<SendMessageRequest>, PDone> {
        @Nullable
        abstract SqsClientProvider getSqsClientProvider();

        abstract Builder builder();

        public Write withSqsClientProvider(SqsClientProvider awsClientsProvider) {
            return this.builder().setSqsClientProvider(awsClientsProvider).build();
        }

        public Write withSqsClientProvider(AwsCredentialsProvider credentialsProvider, String region) {
            return this.withSqsClientProvider(credentialsProvider, region, null);
        }

        public Write withSqsClientProvider(AwsCredentialsProvider credentialsProvider, String region, URI serviceEndpoint) {
            return this.withSqsClientProvider(new BasicSqsClientProvider(credentialsProvider, region, serviceEndpoint));
        }

        public PDone expand(PCollection<SendMessageRequest> input) {
            input.apply((PTransform)ParDo.of((DoFn)new SqsWriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSqsClientProvider(SqsClientProvider var1);

            abstract Write build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<SqsMessage>> {
        @Nullable
        abstract String queueUrl();

        abstract long maxNumRecords();

        @Nullable
        abstract Duration maxReadTime();

        @Nullable
        abstract SqsClientProvider sqsClientProvider();

        abstract Builder builder();

        public Read withMaxNumRecords(long maxNumRecords) {
            return this.builder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read withMaxReadTime(Duration maxReadTime) {
            return this.builder().setMaxReadTime(maxReadTime).build();
        }

        public Read withQueueUrl(String queueUrl) {
            Preconditions.checkArgument((queueUrl != null ? 1 : 0) != 0, (Object)"queueUrl can not be null");
            Preconditions.checkArgument((!queueUrl.isEmpty() ? 1 : 0) != 0, (Object)"queueUrl can not be empty");
            return this.builder().setQueueUrl(queueUrl).build();
        }

        public Read withSqsClientProvider(SqsClientProvider awsClientsProvider) {
            return this.builder().setSqsClientProvider(awsClientsProvider).build();
        }

        public Read withSqsClientProvider(AwsCredentialsProvider credentialsProvider, String region) {
            return this.withSqsClientProvider(credentialsProvider, region, null);
        }

        public Read withSqsClientProvider(AwsCredentialsProvider credentialsProvider, String region, URI serviceEndpoint) {
            return this.withSqsClientProvider(new BasicSqsClientProvider(credentialsProvider, region, serviceEndpoint));
        }

        public PCollection<SqsMessage> expand(PBegin input) {
            Read.Unbounded unbounded;
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new SqsUnboundedSource(this));
            if (this.maxNumRecords() < Long.MAX_VALUE || this.maxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.maxReadTime()).withMaxNumRecords(this.maxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setQueueUrl(String var1);

            abstract Builder setMaxNumRecords(long var1);

            abstract Builder setMaxReadTime(Duration var1);

            abstract Builder setSqsClientProvider(SqsClientProvider var1);

            abstract Read build();
        }
    }
}

