/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class SendMessageRequestCoder
extends AtomicCoder<SendMessageRequest>
implements Serializable {
    private static final SendMessageRequestCoder INSTANCE = new SendMessageRequestCoder();

    private SendMessageRequestCoder() {
    }

    static SendMessageRequestCoder of() {
        return INSTANCE;
    }

    public void encode(SendMessageRequest value, OutputStream outStream) throws IOException {
        StringUtf8Coder.of().encode(value.queueUrl(), outStream);
        StringUtf8Coder.of().encode(value.messageBody(), outStream);
    }

    public SendMessageRequest decode(InputStream inStream) throws IOException {
        String queueUrl = StringUtf8Coder.of().decode(inStream);
        String message = StringUtf8Coder.of().decode(inStream);
        return (SendMessageRequest)SendMessageRequest.builder().queueUrl(queueUrl).messageBody(message).build();
    }
}

