/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.net.URI;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.sqs.SqsClientProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

class BasicSqsClientProvider
implements SqsClientProvider {
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final String region;
    @Nullable
    private final URI serviceEndpoint;

    BasicSqsClientProvider(AwsCredentialsProvider awsCredentialsProvider, String region, @Nullable URI serviceEndpoint) {
        Preconditions.checkArgument((awsCredentialsProvider != null ? 1 : 0) != 0, (Object)"awsCredentialsProvider can not be null");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"region can not be null");
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.region = region;
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    public SqsClient getSqsClient() {
        SqsClientBuilder builder = (SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().credentialsProvider(this.awsCredentialsProvider)).region(Region.of((String)this.region));
        if (this.serviceEndpoint != null) {
            builder.endpointOverride(this.serviceEndpoint);
        }
        return (SqsClient)builder.build();
    }
}

