/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.aws2.sns.AutoValue_SnsIO_RetryConfiguration;
import org.apache.beam.sdk.io.aws2.sns.AutoValue_SnsIO_Write;
import org.apache.beam.sdk.io.aws2.sns.BasicSnsClientProvider;
import org.apache.beam.sdk.io.aws2.sns.SnsClientProvider;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.InternalErrorException;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public final class SnsIO {
    public static <T> Write<T> write() {
        return new AutoValue_SnsIO_Write.Builder().build();
    }

    @AutoValue
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PCollection<PublishResponse>> {
        @Nullable
        abstract String getTopicArn();

        @Nullable
        abstract SerializableFunction<T, PublishRequest> getPublishRequestFn();

        @Nullable
        abstract SnsClientProvider getSnsClientProvider();

        @Nullable
        abstract RetryConfiguration getRetryConfiguration();

        abstract Builder<T> builder();

        public Write<T> withTopicArn(String topicArn) {
            return this.builder().setTopicArn(topicArn).build();
        }

        public Write<T> withPublishRequestFn(SerializableFunction<T, PublishRequest> publishRequestFn) {
            return this.builder().setPublishRequestFn(publishRequestFn).build();
        }

        public Write<T> withSnsClientProvider(SnsClientProvider awsClientsProvider) {
            return this.builder().setSnsClientProvider(awsClientsProvider).build();
        }

        public Write<T> withSnsClientProvider(AwsCredentialsProvider credentialsProvider, String region) {
            return this.withSnsClientProvider(credentialsProvider, region, null);
        }

        public Write<T> withSnsClientProvider(AwsCredentialsProvider credentialsProvider, String region, URI serviceEndpoint) {
            return this.withSnsClientProvider(new BasicSnsClientProvider(credentialsProvider, region, serviceEndpoint));
        }

        public Write<T> withRetryConfiguration(RetryConfiguration retryConfiguration) {
            Preconditions.checkArgument((retryConfiguration != null ? 1 : 0) != 0, (Object)"retryConfiguration is required");
            return this.builder().setRetryConfiguration(retryConfiguration).build();
        }

        private static boolean isTopicExists(SnsClient client, String topicArn) {
            GetTopicAttributesRequest getTopicAttributesRequest = (GetTopicAttributesRequest)GetTopicAttributesRequest.builder().topicArn(topicArn).build();
            GetTopicAttributesResponse topicAttributesResponse = client.getTopicAttributes(getTopicAttributesRequest);
            return topicAttributesResponse != null && topicAttributesResponse.sdkHttpResponse().statusCode() == 200;
        }

        public PCollection<PublishResponse> expand(PCollection<T> input) {
            Preconditions.checkArgument((this.getTopicArn() != null ? 1 : 0) != 0, (Object)"withTopicArn() is required");
            Preconditions.checkArgument((this.getPublishRequestFn() != null ? 1 : 0) != 0, (Object)"withPublishRequestFn() is required");
            Preconditions.checkArgument((this.getSnsClientProvider() != null ? 1 : 0) != 0, (Object)"withSnsClientProvider() is required");
            Preconditions.checkArgument((boolean)Write.isTopicExists(this.getSnsClientProvider().getSnsClient(), this.getTopicArn()), (String)"Topic arn %s does not exist", (Object)this.getTopicArn());
            return (PCollection)input.apply((PTransform)ParDo.of(new SnsWriterFn(this)));
        }

        static class SnsWriterFn<T>
        extends DoFn<T, PublishResponse> {
            @VisibleForTesting
            static final String RETRY_ATTEMPT_LOG = "Error writing to SNS. Retry attempt[%d]";
            private static final Duration RETRY_INITIAL_BACKOFF = Duration.standardSeconds((long)5L);
            private transient FluentBackoff retryBackoff;
            private static final Logger LOG = LoggerFactory.getLogger(SnsWriterFn.class);
            private static final Counter SNS_WRITE_FAILURES = Metrics.counter(SnsWriterFn.class, (String)"SNS_Write_Failures");
            private final Write spec;
            private transient SnsClient producer;

            SnsWriterFn(Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                this.producer = this.spec.getSnsClientProvider().getSnsClient();
                this.retryBackoff = FluentBackoff.DEFAULT.withMaxRetries(0).withInitialBackoff(RETRY_INITIAL_BACKOFF);
                if (this.spec.getRetryConfiguration() != null) {
                    this.retryBackoff = this.retryBackoff.withMaxRetries(this.spec.getRetryConfiguration().getMaxAttempts() - 1).withMaxCumulativeBackoff(this.spec.getRetryConfiguration().getMaxDuration());
                }
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                PublishRequest request = (PublishRequest)this.spec.getPublishRequestFn().apply(context.element());
                Sleeper sleeper = Sleeper.DEFAULT;
                BackOff backoff = this.retryBackoff.backoff();
                int attempt = 0;
                while (true) {
                    ++attempt;
                    try {
                        PublishResponse pr = this.producer.publish(request);
                        context.output((Object)pr);
                    }
                    catch (Exception ex) {
                        if (this.spec.getRetryConfiguration() == null || !this.spec.getRetryConfiguration().getRetryPredicate().test(ex)) {
                            SNS_WRITE_FAILURES.inc();
                            LOG.info("Unable to publish message {} due to {} ", (Object)request.message(), (Object)ex);
                            throw new IOException("Error writing to SNS (no attempt made to retry)", ex);
                        }
                        if (!BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff)) {
                            throw new IOException(String.format("Error writing to SNS after %d attempt(s). No more attempts allowed", attempt), ex);
                        }
                        LOG.warn(String.format(RETRY_ATTEMPT_LOG, attempt), (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }

            @DoFn.Teardown
            public void tearDown() {
                if (this.producer != null) {
                    this.producer.close();
                    this.producer = null;
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setTopicArn(String var1);

            abstract Builder<T> setPublishRequestFn(SerializableFunction<T, PublishRequest> var1);

            abstract Builder<T> setSnsClientProvider(SnsClientProvider var1);

            abstract Builder<T> setRetryConfiguration(RetryConfiguration var1);

            abstract Write<T> build();
        }
    }

    @AutoValue
    public static abstract class RetryConfiguration
    implements Serializable {
        @VisibleForTesting
        static final RetryPredicate DEFAULT_RETRY_PREDICATE = new DefaultRetryPredicate();

        abstract int getMaxAttempts();

        abstract Duration getMaxDuration();

        abstract RetryPredicate getRetryPredicate();

        abstract Builder builder();

        public static RetryConfiguration create(int maxAttempts, Duration maxDuration) {
            Preconditions.checkArgument((maxAttempts > 0 ? 1 : 0) != 0, (Object)"maxAttempts should be greater than 0");
            Preconditions.checkArgument((maxDuration != null && maxDuration.isLongerThan((ReadableDuration)Duration.ZERO) ? 1 : 0) != 0, (Object)"maxDuration should be greater than 0");
            return new AutoValue_SnsIO_RetryConfiguration.Builder().setMaxAttempts(maxAttempts).setMaxDuration(maxDuration).setRetryPredicate(DEFAULT_RETRY_PREDICATE).build();
        }

        private static class DefaultRetryPredicate
        implements RetryPredicate {
            private static final ImmutableSet<Integer> ELIGIBLE_CODES = ImmutableSet.of((Object)503);

            private DefaultRetryPredicate() {
            }

            @Override
            public boolean test(Throwable throwable) {
                return throwable instanceof IOException || throwable instanceof InternalErrorException || throwable instanceof InternalErrorException && ELIGIBLE_CODES.contains((Object)((InternalErrorException)throwable).statusCode());
            }
        }

        @FunctionalInterface
        static interface RetryPredicate
        extends Predicate<Throwable>,
        Serializable {
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setMaxAttempts(int var1);

            abstract Builder setMaxDuration(Duration var1);

            abstract Builder setRetryPredicate(RetryPredicate var1);

            abstract RetryConfiguration build();
        }
    }
}

