/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import java.net.URI;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.sns.SnsClientProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;

class BasicSnsClientProvider
implements SnsClientProvider {
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final String region;
    @Nullable
    private final URI serviceEndpoint;

    BasicSnsClientProvider(AwsCredentialsProvider awsCredentialsProvider, String region, @Nullable URI serviceEndpoint) {
        Preconditions.checkArgument((awsCredentialsProvider != null ? 1 : 0) != 0, (Object)"awsCredentialsProvider can not be null");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"region can not be null");
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.region = region;
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    public SnsClient getSnsClient() {
        SnsClientBuilder builder = (SnsClientBuilder)((SnsClientBuilder)SnsClient.builder().credentialsProvider(this.awsCredentialsProvider)).region(Region.of((String)this.region));
        if (this.serviceEndpoint != null) {
            builder.endpointOverride(this.serviceEndpoint);
        }
        return (SnsClient)builder.build();
    }
}

