/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import org.apache.beam.sdk.io.aws2.sns.SnsIO;
import org.joda.time.Duration;

final class AutoValue_SnsIO_RetryConfiguration
extends SnsIO.RetryConfiguration {
    private final int maxAttempts;
    private final Duration maxDuration;
    private final SnsIO.RetryConfiguration.RetryPredicate retryPredicate;

    private AutoValue_SnsIO_RetryConfiguration(int maxAttempts, Duration maxDuration, SnsIO.RetryConfiguration.RetryPredicate retryPredicate) {
        this.maxAttempts = maxAttempts;
        this.maxDuration = maxDuration;
        this.retryPredicate = retryPredicate;
    }

    @Override
    int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    Duration getMaxDuration() {
        return this.maxDuration;
    }

    @Override
    SnsIO.RetryConfiguration.RetryPredicate getRetryPredicate() {
        return this.retryPredicate;
    }

    public String toString() {
        return "RetryConfiguration{maxAttempts=" + this.maxAttempts + ", maxDuration=" + this.maxDuration + ", retryPredicate=" + this.retryPredicate + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SnsIO.RetryConfiguration) {
            SnsIO.RetryConfiguration that = (SnsIO.RetryConfiguration)o;
            return this.maxAttempts == that.getMaxAttempts() && this.maxDuration.equals((Object)that.getMaxDuration()) && this.retryPredicate.equals(that.getRetryPredicate());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.maxAttempts;
        h$ *= 1000003;
        h$ ^= this.maxDuration.hashCode();
        h$ *= 1000003;
        return h$ ^= this.retryPredicate.hashCode();
    }

    @Override
    SnsIO.RetryConfiguration.Builder builder() {
        return new Builder(this);
    }

    static final class Builder
    extends SnsIO.RetryConfiguration.Builder {
        private Integer maxAttempts;
        private Duration maxDuration;
        private SnsIO.RetryConfiguration.RetryPredicate retryPredicate;

        Builder() {
        }

        private Builder(SnsIO.RetryConfiguration source) {
            this.maxAttempts = source.getMaxAttempts();
            this.maxDuration = source.getMaxDuration();
            this.retryPredicate = source.getRetryPredicate();
        }

        @Override
        SnsIO.RetryConfiguration.Builder setMaxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        @Override
        SnsIO.RetryConfiguration.Builder setMaxDuration(Duration maxDuration) {
            if (maxDuration == null) {
                throw new NullPointerException("Null maxDuration");
            }
            this.maxDuration = maxDuration;
            return this;
        }

        @Override
        SnsIO.RetryConfiguration.Builder setRetryPredicate(SnsIO.RetryConfiguration.RetryPredicate retryPredicate) {
            if (retryPredicate == null) {
                throw new NullPointerException("Null retryPredicate");
            }
            this.retryPredicate = retryPredicate;
            return this;
        }

        @Override
        SnsIO.RetryConfiguration build() {
            String missing = "";
            if (this.maxAttempts == null) {
                missing = missing + " maxAttempts";
            }
            if (this.maxDuration == null) {
                missing = missing + " maxDuration";
            }
            if (this.retryPredicate == null) {
                missing = missing + " retryPredicate";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SnsIO_RetryConfiguration(this.maxAttempts, this.maxDuration, this.retryPredicate);
        }
    }
}

