/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.http.apache.ProxyConfiguration;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class AwsModule
extends SimpleModule {
    private static final String ACCESS_KEY_ID = "accessKeyId";
    private static final String SECRET_ACCESS_KEY = "secretAccessKey";

    public AwsModule() {
        super("AwsModule");
        this.setMixInAnnotation(AwsCredentialsProvider.class, AwsCredentialsProviderMixin.class);
        this.setMixInAnnotation(ProxyConfiguration.class, ProxyConfigurationMixin.class);
    }

    private static class ProxyConfigurationSerializer
    extends JsonSerializer<ProxyConfiguration> {
        private ProxyConfigurationSerializer() {
        }

        public void serialize(ProxyConfiguration proxyConfiguration, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            String endpoint = proxyConfiguration.scheme() + "://" + proxyConfiguration.host() + ":" + proxyConfiguration.port();
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("endpoint", endpoint);
            jsonGenerator.writeStringField("username", proxyConfiguration.username());
            jsonGenerator.writeStringField("password", proxyConfiguration.password());
            jsonGenerator.writeEndObject();
        }
    }

    private static class ProxyConfigurationDeserializer
    extends JsonDeserializer<ProxyConfiguration> {
        private ProxyConfigurationDeserializer() {
        }

        public ProxyConfiguration deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Map asMap = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            return (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create((String)asMap.get("endpoint"))).username((String)asMap.get("username")).password((String)asMap.get("password")).useSystemPropertyValues(Boolean.valueOf((String)asMap.get("useSystemPropertyValues"))).build();
        }
    }

    @JsonDeserialize(using=ProxyConfigurationDeserializer.class)
    @JsonSerialize(using=ProxyConfigurationSerializer.class)
    private static class ProxyConfigurationMixin {
        private ProxyConfigurationMixin() {
        }
    }

    private static class AWSCredentialsProviderSerializer
    extends JsonSerializer<AwsCredentialsProvider> {
        private static final ImmutableSet<Object> SINGLETON_CREDENTIAL_PROVIDERS = ImmutableSet.of(DefaultCredentialsProvider.class, EnvironmentVariableCredentialsProvider.class, SystemPropertyCredentialsProvider.class, ProfileCredentialsProvider.class, ContainerCredentialsProvider.class);

        private AWSCredentialsProviderSerializer() {
        }

        public void serialize(AwsCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            serializer.defaultSerializeValue((Object)credentialsProvider, jsonGenerator);
        }

        public void serializeWithType(AwsCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializer, TypeSerializer typeSerializer) throws IOException {
            WritableTypeId typeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId((Object)credentialsProvider, JsonToken.START_OBJECT));
            if (credentialsProvider.getClass().equals(StaticCredentialsProvider.class)) {
                jsonGenerator.writeStringField(AwsModule.ACCESS_KEY_ID, credentialsProvider.resolveCredentials().accessKeyId());
                jsonGenerator.writeStringField(AwsModule.SECRET_ACCESS_KEY, credentialsProvider.resolveCredentials().secretAccessKey());
            } else if (!SINGLETON_CREDENTIAL_PROVIDERS.contains(credentialsProvider.getClass())) {
                throw new IllegalArgumentException("Unsupported AWS credentials provider type " + credentialsProvider.getClass());
            }
            typeSerializer.writeTypeSuffix(jsonGenerator, typeId);
        }
    }

    private static class AwsCredentialsProviderDeserializer
    extends JsonDeserializer<AwsCredentialsProvider> {
        private AwsCredentialsProviderDeserializer() {
        }

        public AwsCredentialsProvider deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return (AwsCredentialsProvider)context.readValue(jsonParser, AwsCredentialsProvider.class);
        }

        public AwsCredentialsProvider deserializeWithType(JsonParser jsonParser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
            String typeNameKey;
            Map asMap = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            String typeName = (String)asMap.get(typeNameKey = typeDeserializer.getPropertyName());
            if (typeName == null) {
                throw new IOException(String.format("AWS credentials provider type name key '%s' not found", typeNameKey));
            }
            if (typeName.equals(StaticCredentialsProvider.class.getSimpleName())) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)((String)asMap.get(AwsModule.ACCESS_KEY_ID)), (String)((String)asMap.get(AwsModule.SECRET_ACCESS_KEY))));
            }
            if (typeName.equals(DefaultCredentialsProvider.class.getSimpleName())) {
                return DefaultCredentialsProvider.create();
            }
            if (typeName.equals(EnvironmentVariableCredentialsProvider.class.getSimpleName())) {
                return EnvironmentVariableCredentialsProvider.create();
            }
            if (typeName.equals(SystemPropertyCredentialsProvider.class.getSimpleName())) {
                return SystemPropertyCredentialsProvider.create();
            }
            if (typeName.equals(ProfileCredentialsProvider.class.getSimpleName())) {
                return ProfileCredentialsProvider.create();
            }
            if (typeName.equals(ContainerCredentialsProvider.class.getSimpleName())) {
                return ContainerCredentialsProvider.builder().build();
            }
            throw new IOException(String.format("AWS credential provider type '%s' is not supported", typeName));
        }
    }

    @JsonDeserialize(using=AwsCredentialsProviderDeserializer.class)
    @JsonSerialize(using=AWSCredentialsProviderSerializer.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    private static class AwsCredentialsProviderMixin {
        private AwsCredentialsProviderMixin() {
        }
    }
}

