/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import java.net.URI;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.dynamodb.DynamoDbClientProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

public class BasicDynamoDbClientProvider
implements DynamoDbClientProvider {
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final String region;
    @Nullable
    private final URI serviceEndpoint;

    BasicDynamoDbClientProvider(AwsCredentialsProvider awsCredentialsProvider, String region, @Nullable URI serviceEndpoint) {
        Preconditions.checkArgument((awsCredentialsProvider != null ? 1 : 0) != 0, (Object)"awsCredentialsProvider can not be null");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"region can not be null");
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.region = region;
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    public DynamoDbClient getDynamoDbClient() {
        DynamoDbClientBuilder builder = (DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().credentialsProvider(this.awsCredentialsProvider)).region(Region.of((String)this.region));
        if (this.serviceEndpoint != null) {
            builder.endpointOverride(this.serviceEndpoint);
        }
        return (DynamoDbClient)builder.build();
    }
}

