/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.options;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;

public interface AwsOptions
extends PipelineOptions {
    @Description(value="AWS region used by the AWS client")
    @Validation.Required
    public String getAwsRegion();

    public void setAwsRegion(String var1);

    @Description(value="AWS service endpoint used by the AWS client")
    public String getAwsServiceEndpoint();

    public void setAwsServiceEndpoint(String var1);

    @Description(value="The credential instance that should be used to authenticate against AWS services. The option value must contain \"@type\" field and an AWS Credentials Provider class name as the field value. Refer to DefaultAWSCredentialsProviderChain Javadoc for usage help. For example, to specify the AWS key ID and secret, specify the following: {\"@type\": \"AWSStaticCredentialsProvider\", \"awsAccessKeyId\":\"<key_id>\", \"awsSecretKey\":\"<secret_key>\"}")
    @Default.InstanceFactory(value=AwsUserCredentialsFactory.class)
    public AWSCredentialsProvider getAwsCredentialsProvider();

    public void setAwsCredentialsProvider(AWSCredentialsProvider var1);

    @Description(value="The client configuration instance that should be used to configure AWS service clients. Please note that the configuration deserialization only allows one to specify proxy settings. For example, to specify the proxy host, port, username and password, specify the following: --clientConfiguration={\"proxyHost\":\"hostname\",\"proxyPort\":1234,\"proxyUsername\":\"username\",\"proxyPassword\":\"password\"}")
    @Default.InstanceFactory(value=ClientConfigurationFactory.class)
    public ClientConfiguration getClientConfiguration();

    public void setClientConfiguration(ClientConfiguration var1);

    public static class ClientConfigurationFactory
    implements DefaultValueFactory<ClientConfiguration> {
        public ClientConfiguration create(PipelineOptions options) {
            return new ClientConfiguration();
        }
    }

    public static class AwsUserCredentialsFactory
    implements DefaultValueFactory<AWSCredentialsProvider> {
        public AWSCredentialsProvider create(PipelineOptions options) {
            return DefaultAWSCredentialsProviderChain.getInstance();
        }
    }
}

