/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.sdk.io.aws.s3.S3ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

class S3ReadableSeekableByteChannel
implements SeekableByteChannel {
    private final AmazonS3 amazonS3;
    private final S3ResourceId path;
    private final long contentLength;
    private long position = 0L;
    private boolean open = true;
    private S3Object s3Object;
    private final S3Options options;
    private ReadableByteChannel s3ObjectContentChannel;

    S3ReadableSeekableByteChannel(AmazonS3 amazonS3, S3ResourceId path, S3Options options) throws IOException {
        this.amazonS3 = (AmazonS3)Preconditions.checkNotNull((Object)amazonS3, (Object)"amazonS3");
        Preconditions.checkNotNull((Object)path, (Object)"path");
        this.options = (S3Options)Preconditions.checkNotNull((Object)options, (Object)"options");
        if (path.getSize().isPresent()) {
            this.contentLength = (Long)path.getSize().get();
            this.path = path;
        } else {
            try {
                this.contentLength = amazonS3.getObjectMetadata(path.getBucket(), path.getKey()).getContentLength();
            }
            catch (AmazonClientException e) {
                throw new IOException(e);
            }
            this.path = path.withSize(this.contentLength);
        }
    }

    @Override
    public int read(ByteBuffer destinationBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!destinationBuffer.hasRemaining()) {
            return 0;
        }
        if (this.position == this.contentLength) {
            return -1;
        }
        if (this.s3Object == null) {
            GetObjectRequest request = new GetObjectRequest(this.path.getBucket(), this.path.getKey());
            request.setSSECustomerKey(this.options.getSSECustomerKey());
            if (this.position > 0L) {
                request.setRange(this.position, this.contentLength);
            }
            try {
                this.s3Object = this.amazonS3.getObject(request);
            }
            catch (AmazonClientException e) {
                throw new IOException(e);
            }
            this.s3ObjectContentChannel = Channels.newChannel(new BufferedInputStream((InputStream)this.s3Object.getObjectContent(), 0x100000));
        }
        int totalBytesRead = 0;
        int bytesRead = 0;
        do {
            totalBytesRead += bytesRead;
            try {
                bytesRead = this.s3ObjectContentChannel.read(destinationBuffer);
            }
            catch (AmazonClientException e) {
                throw new IOException(e);
            }
        } while (bytesRead > 0);
        this.position += (long)totalBytesRead;
        return totalBytesRead;
    }

    @Override
    public long position() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0, (Object)"newPosition too low");
        Preconditions.checkArgument((newPosition < this.contentLength ? 1 : 0) != 0, (Object)"new position too high");
        if (newPosition == this.position) {
            return this;
        }
        if (this.s3Object != null) {
            this.s3Object.close();
            this.s3Object = null;
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.contentLength;
    }

    @Override
    public void close() throws IOException {
        if (this.s3Object != null) {
            this.s3Object.close();
        }
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public int write(ByteBuffer src) {
        throw new NonWritableChannelException();
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new NonWritableChannelException();
    }
}

