/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.options;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

public class AwsModule
extends SimpleModule {
    private static final String AWS_ACCESS_KEY_ID = "awsAccessKeyId";
    private static final String AWS_SECRET_KEY = "awsSecretKey";
    private static final String CREDENTIALS_FILE_PATH = "credentialsFilePath";

    public AwsModule() {
        super("AwsModule");
        this.setMixInAnnotation(AWSCredentialsProvider.class, AWSCredentialsProviderMixin.class);
        this.setMixInAnnotation(SSECustomerKey.class, SSECustomerKeyMixin.class);
        this.setMixInAnnotation(SSEAwsKeyManagementParams.class, SSEAwsKeyManagementParamsMixin.class);
        this.setMixInAnnotation(ClientConfiguration.class, ClientConfigurationMixin.class);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    static interface ClientConfigurationMixin {
        @JsonProperty
        public String getProxyHost();

        @JsonProperty
        public Integer getProxyPort();

        @JsonProperty
        public String getProxyUsername();

        @JsonProperty
        public String getProxyPassword();
    }

    private static class SSEAwsKeyManagementParamsDeserializer
    extends JsonDeserializer<SSEAwsKeyManagementParams> {
        private SSEAwsKeyManagementParamsDeserializer() {
        }

        public SSEAwsKeyManagementParams deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Map asMap = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            String awsKmsKeyId = asMap.getOrDefault("awsKmsKeyId", null);
            return new SSEAwsKeyManagementParams(awsKmsKeyId);
        }
    }

    @JsonDeserialize(using=SSEAwsKeyManagementParamsDeserializer.class)
    private static class SSEAwsKeyManagementParamsMixin {
        private SSEAwsKeyManagementParamsMixin() {
        }
    }

    private static class SSECustomerKeyDeserializer
    extends JsonDeserializer<SSECustomerKey> {
        private SSECustomerKeyDeserializer() {
        }

        public SSECustomerKey deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Map asMap = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            String key = asMap.getOrDefault("key", null);
            String algorithm = asMap.getOrDefault("algorithm", null);
            String md5 = asMap.getOrDefault("md5", null);
            SSECustomerKey sseCustomerKey = new SSECustomerKey(key);
            if (algorithm != null) {
                sseCustomerKey.setAlgorithm(algorithm);
            }
            if (md5 != null) {
                sseCustomerKey.setMd5(md5);
            }
            return sseCustomerKey;
        }
    }

    @JsonDeserialize(using=SSECustomerKeyDeserializer.class)
    private static class SSECustomerKeyMixin {
        private SSECustomerKeyMixin() {
        }
    }

    private static class AWSCredentialsProviderSerializer
    extends JsonSerializer<AWSCredentialsProvider> {
        private static final ImmutableSet<Object> SINGLETON_CREDENTIAL_PROVIDERS = ImmutableSet.of(DefaultAWSCredentialsProviderChain.class, EnvironmentVariableCredentialsProvider.class, SystemPropertiesCredentialsProvider.class, ProfileCredentialsProvider.class, EC2ContainerCredentialsProviderWrapper.class);

        private AWSCredentialsProviderSerializer() {
        }

        public void serialize(AWSCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            serializers.defaultSerializeValue((Object)credentialsProvider, jsonGenerator);
        }

        public void serializeWithType(AWSCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForObject((Object)credentialsProvider, jsonGenerator);
            if (credentialsProvider.getClass().equals(AWSStaticCredentialsProvider.class)) {
                jsonGenerator.writeStringField(AwsModule.AWS_ACCESS_KEY_ID, credentialsProvider.getCredentials().getAWSAccessKeyId());
                jsonGenerator.writeStringField(AwsModule.AWS_SECRET_KEY, credentialsProvider.getCredentials().getAWSSecretKey());
            } else if (credentialsProvider.getClass().equals(PropertiesFileCredentialsProvider.class)) {
                try {
                    PropertiesFileCredentialsProvider specificProvider = (PropertiesFileCredentialsProvider)credentialsProvider;
                    Field field = PropertiesFileCredentialsProvider.class.getDeclaredField(AwsModule.CREDENTIALS_FILE_PATH);
                    field.setAccessible(true);
                    String credentialsFilePath = (String)field.get(specificProvider);
                    jsonGenerator.writeStringField(AwsModule.CREDENTIALS_FILE_PATH, credentialsFilePath);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IOException("failed to access private field with reflection", e);
                }
            } else if (credentialsProvider.getClass().equals(ClasspathPropertiesFileCredentialsProvider.class)) {
                try {
                    ClasspathPropertiesFileCredentialsProvider specificProvider = (ClasspathPropertiesFileCredentialsProvider)credentialsProvider;
                    Field field = ClasspathPropertiesFileCredentialsProvider.class.getDeclaredField(AwsModule.CREDENTIALS_FILE_PATH);
                    field.setAccessible(true);
                    String credentialsFilePath = (String)field.get(specificProvider);
                    jsonGenerator.writeStringField(AwsModule.CREDENTIALS_FILE_PATH, credentialsFilePath);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IOException("failed to access private field with reflection", e);
                }
            } else if (!SINGLETON_CREDENTIAL_PROVIDERS.contains(credentialsProvider.getClass())) {
                throw new IllegalArgumentException("Unsupported AWS credentials provider type " + credentialsProvider.getClass());
            }
            typeSerializer.writeTypeSuffixForObject((Object)credentialsProvider, jsonGenerator);
        }
    }

    private static class AWSCredentialsProviderDeserializer
    extends JsonDeserializer<AWSCredentialsProvider> {
        private AWSCredentialsProviderDeserializer() {
        }

        public AWSCredentialsProvider deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return (AWSCredentialsProvider)context.readValue(jsonParser, AWSCredentialsProvider.class);
        }

        public AWSCredentialsProvider deserializeWithType(JsonParser jsonParser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
            String typeNameKey;
            Map asMap = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            String typeName = (String)asMap.get(typeNameKey = typeDeserializer.getPropertyName());
            if (typeName == null) {
                throw new IOException(String.format("AWS credentials provider type name key '%s' not found", typeNameKey));
            }
            if (typeName.equals(AWSStaticCredentialsProvider.class.getSimpleName())) {
                return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials((String)asMap.get(AwsModule.AWS_ACCESS_KEY_ID), (String)asMap.get(AwsModule.AWS_SECRET_KEY)));
            }
            if (typeName.equals(PropertiesFileCredentialsProvider.class.getSimpleName())) {
                return new PropertiesFileCredentialsProvider((String)asMap.get(AwsModule.CREDENTIALS_FILE_PATH));
            }
            if (typeName.equals(ClasspathPropertiesFileCredentialsProvider.class.getSimpleName())) {
                return new ClasspathPropertiesFileCredentialsProvider((String)asMap.get(AwsModule.CREDENTIALS_FILE_PATH));
            }
            if (typeName.equals(DefaultAWSCredentialsProviderChain.class.getSimpleName())) {
                return new DefaultAWSCredentialsProviderChain();
            }
            if (typeName.equals(EnvironmentVariableCredentialsProvider.class.getSimpleName())) {
                return new EnvironmentVariableCredentialsProvider();
            }
            if (typeName.equals(SystemPropertiesCredentialsProvider.class.getSimpleName())) {
                return new SystemPropertiesCredentialsProvider();
            }
            if (typeName.equals(ProfileCredentialsProvider.class.getSimpleName())) {
                return new ProfileCredentialsProvider();
            }
            if (typeName.equals(EC2ContainerCredentialsProviderWrapper.class.getSimpleName())) {
                return new EC2ContainerCredentialsProviderWrapper();
            }
            throw new IOException(String.format("AWS credential provider type '%s' is not supported", typeName));
        }
    }

    @JsonDeserialize(using=AWSCredentialsProviderDeserializer.class)
    @JsonSerialize(using=AWSCredentialsProviderSerializer.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
    private static class AWSCredentialsProviderMixin {
        private AWSCredentialsProviderMixin() {
        }
    }
}

