/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sns;

import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.PublishRequest;
import java.io.Serializable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.aws.sns.AmazonSNSMockErrors;
import org.apache.beam.sdk.io.aws.sns.AmazonSNSMockSuccess;
import org.apache.beam.sdk.io.aws.sns.AwsClientsProvider;
import org.apache.beam.sdk.io.aws.sns.SnsIO;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SnsIOTest
implements Serializable {
    private static final String topicName = "arn:aws:sns:us-west-2:5880:topic-FMFEHJ47NRFO";
    @Rule
    public TestPipeline p = TestPipeline.create();
    @Rule
    public final transient ExpectedLogs expectedLogs = ExpectedLogs.none(SnsIO.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private static PublishRequest createSampleMessage(String message) {
        return new PublishRequest().withTopicArn(topicName).withMessage(message);
    }

    @Test
    public void testDataWritesToSNS() {
        PublishRequest request1 = SnsIOTest.createSampleMessage("my_first_message");
        PublishRequest request2 = SnsIOTest.createSampleMessage("my_second_message");
        TupleTag results = new TupleTag();
        PCollectionTuple snsWrites = (PCollectionTuple)((PCollection)this.p.apply((PTransform)Create.of((Object)request1, (Object[])new PublishRequest[]{request2}))).apply((PTransform)SnsIO.write().withTopicName(topicName).withRetryConfiguration(SnsIO.RetryConfiguration.create((int)5, (Duration)Duration.standardMinutes((long)1L))).withAWSClientsProvider((AwsClientsProvider)new Provider(new AmazonSNSMockSuccess())).withResultOutputTag(results));
        PCollection publishedResultsSize = (PCollection)snsWrites.get(results).apply(Count.globally());
        PAssert.that((PCollection)publishedResultsSize).containsInAnyOrder((Iterable)ImmutableList.of((Object)2L));
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testRetries() throws Throwable {
        this.thrown.expectMessage("Error writing to SNS");
        PublishRequest request1 = SnsIOTest.createSampleMessage("my message that will not be published");
        TupleTag results = new TupleTag();
        ((PCollection)this.p.apply((PTransform)Create.of((Object)request1, (Object[])new PublishRequest[0]))).apply((PTransform)SnsIO.write().withTopicName(topicName).withRetryConfiguration(SnsIO.RetryConfiguration.create((int)4, (Duration)Duration.standardSeconds((long)10L))).withAWSClientsProvider((AwsClientsProvider)new Provider(new AmazonSNSMockErrors())).withResultOutputTag(results));
        try {
            this.p.run();
        }
        catch (Pipeline.PipelineExecutionException e) {
            this.expectedLogs.verifyWarn(String.format("Error writing to SNS. Retry attempt[%d]", 1));
            this.expectedLogs.verifyWarn(String.format("Error writing to SNS. Retry attempt[%d]", 2));
            this.expectedLogs.verifyWarn(String.format("Error writing to SNS. Retry attempt[%d]", 3));
            throw e.getCause();
        }
        Assert.fail((String)"Pipeline is expected to fail because we were unable to write to SNS.");
    }

    private static class Provider
    implements AwsClientsProvider {
        private static AmazonSNS publisher;

        public Provider(AmazonSNS pub) {
            publisher = pub;
        }

        public AmazonCloudWatch getCloudWatchClient() {
            return (AmazonCloudWatch)Mockito.mock(AmazonCloudWatch.class);
        }

        public AmazonSNS createSnsPublisher() {
            return publisher;
        }
    }
}

