/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.sdk.io.aws.s3.S3ResourceId;
import org.apache.beam.sdk.io.aws.s3.S3TestUtils;
import org.apache.beam.sdk.io.aws.s3.S3WritableByteChannel;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class S3WritableByteChannelTest {
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Test
    public void write() throws IOException {
        this.writeFromOptions(S3TestUtils.s3Options());
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSEAlgorithm());
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSECustomerKey());
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSEAwsKeyManagementParams());
        this.expected.expect(IllegalArgumentException.class);
        this.writeFromOptions(S3TestUtils.s3OptionsWithMultipleSSEOptions());
    }

    private void writeFromOptions(S3Options options) throws IOException {
        AmazonS3 mockAmazonS3 = (AmazonS3)Mockito.mock(AmazonS3.class, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.RETURNS_SMART_NULLS));
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://bucket/dir/file");
        InitiateMultipartUploadResult initiateMultipartUploadResult = new InitiateMultipartUploadResult();
        initiateMultipartUploadResult.setUploadId("upload-id");
        String sseAlgorithm = options.getSSEAlgorithm();
        if (options.getSSEAlgorithm() != null) {
            initiateMultipartUploadResult.setSSEAlgorithm(sseAlgorithm);
        }
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            initiateMultipartUploadResult.setSSECustomerKeyMd5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        if (options.getSSEAwsKeyManagementParams() != null) {
            sseAlgorithm = "aws:kms";
            initiateMultipartUploadResult.setSSEAlgorithm(sseAlgorithm);
        }
        ((AmazonS3)Mockito.doReturn((Object)initiateMultipartUploadResult).when((Object)mockAmazonS3)).initiateMultipartUpload((InitiateMultipartUploadRequest)org.mockito.Matchers.argThat((Matcher)Matchers.notNullValue(InitiateMultipartUploadRequest.class)));
        InitiateMultipartUploadResult mockInitiateMultipartUploadResult = mockAmazonS3.initiateMultipartUpload(new InitiateMultipartUploadRequest(path.getBucket(), path.getKey()));
        Assert.assertEquals((Object)sseAlgorithm, (Object)mockInitiateMultipartUploadResult.getSSEAlgorithm());
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)mockInitiateMultipartUploadResult.getSSECustomerKeyMd5());
        UploadPartResult result = new UploadPartResult();
        result.setETag("etag");
        if (S3TestUtils.getSSECustomerKeyMd5(options) != null) {
            result.setSSECustomerKeyMd5(S3TestUtils.getSSECustomerKeyMd5(options));
        }
        ((AmazonS3)Mockito.doReturn((Object)result).when((Object)mockAmazonS3)).uploadPart((UploadPartRequest)org.mockito.Matchers.argThat((Matcher)Matchers.notNullValue(UploadPartRequest.class)));
        UploadPartResult mockUploadPartResult = mockAmazonS3.uploadPart(new UploadPartRequest());
        Assert.assertEquals((Object)S3TestUtils.getSSECustomerKeyMd5(options), (Object)mockUploadPartResult.getSSECustomerKeyMd5());
        S3WritableByteChannel channel = new S3WritableByteChannel(mockAmazonS3, path, "text/plain", options);
        int contentSize = 0x2080000;
        ByteBuffer uploadContent = ByteBuffer.allocate((int)((double)contentSize * 2.5));
        for (int i = 0; i < contentSize; ++i) {
            uploadContent.put((byte)-1);
        }
        uploadContent.flip();
        int uploadedSize = channel.write(uploadContent);
        Assert.assertEquals((long)contentSize, (long)uploadedSize);
        CompleteMultipartUploadResult completeMultipartUploadResult = new CompleteMultipartUploadResult();
        ((AmazonS3)Mockito.doReturn((Object)completeMultipartUploadResult).when((Object)mockAmazonS3)).completeMultipartUpload((CompleteMultipartUploadRequest)org.mockito.Matchers.argThat((Matcher)Matchers.notNullValue(CompleteMultipartUploadRequest.class)));
        channel.close();
        ((AmazonS3)Mockito.verify((Object)mockAmazonS3, (VerificationMode)Mockito.times((int)2))).initiateMultipartUpload((InitiateMultipartUploadRequest)org.mockito.Matchers.notNull(InitiateMultipartUploadRequest.class));
        int partQuantity = (int)Math.ceil((double)contentSize / (double)options.getS3UploadBufferSizeBytes().intValue()) + 1;
        ((AmazonS3)Mockito.verify((Object)mockAmazonS3, (VerificationMode)Mockito.times((int)partQuantity))).uploadPart((UploadPartRequest)org.mockito.Matchers.notNull(UploadPartRequest.class));
        ((AmazonS3)Mockito.verify((Object)mockAmazonS3, (VerificationMode)Mockito.times((int)1))).completeMultipartUpload((CompleteMultipartUploadRequest)org.mockito.Matchers.notNull(CompleteMultipartUploadRequest.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockAmazonS3});
    }

    @Test
    public void testAtMostOne() {
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true, true}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true, false}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false, false}));
    }
}

