/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.util.Base64;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.sdk.io.aws.s3.DefaultS3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws.s3.S3FileSystem;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.mockito.Mockito;

class S3TestUtils {
    S3TestUtils() {
    }

    static S3Options s3Options() {
        S3Options options = (S3Options)PipelineOptionsFactory.as(S3Options.class);
        options.setAwsRegion("us-west-1");
        options.setS3UploadBufferSizeBytes(Integer.valueOf(0x500000));
        return options;
    }

    static S3Options s3OptionsWithCustomEndpointAndPathStyleAccessEnabled() {
        S3Options options = (S3Options)PipelineOptionsFactory.as(S3Options.class);
        options.setAwsServiceEndpoint("https://s3.custom.dns");
        options.setAwsRegion("no-matter");
        options.setS3UploadBufferSizeBytes(Integer.valueOf(0x500000));
        options.setS3ClientFactoryClass(PathStyleAcccessS3ClientBuilderFactory.class);
        return options;
    }

    static S3Options s3OptionsWithSSEAlgorithm() {
        S3Options options = S3TestUtils.s3Options();
        options.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
        return options;
    }

    static S3Options s3OptionsWithSSECustomerKey() {
        S3Options options = S3TestUtils.s3Options();
        options.setSSECustomerKey(new SSECustomerKey("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA="));
        return options;
    }

    static S3Options s3OptionsWithSSEAwsKeyManagementParams() {
        S3Options options = S3TestUtils.s3Options();
        String awsKmsKeyId = "arn:aws:kms:eu-west-1:123456789012:key/dc123456-7890-ABCD-EF01-234567890ABC";
        SSEAwsKeyManagementParams sseAwsKeyManagementParams = new SSEAwsKeyManagementParams(awsKmsKeyId);
        options.setSSEAwsKeyManagementParams(sseAwsKeyManagementParams);
        return options;
    }

    static S3Options s3OptionsWithMultipleSSEOptions() {
        S3Options options = S3TestUtils.s3OptionsWithSSEAwsKeyManagementParams();
        options.setSSECustomerKey(new SSECustomerKey("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA="));
        return options;
    }

    static S3FileSystem buildMockedS3FileSystem(S3Options options) {
        return S3TestUtils.buildMockedS3FileSystem(options, (AmazonS3)Mockito.mock(AmazonS3.class));
    }

    static S3FileSystem buildMockedS3FileSystem(S3Options options, AmazonS3 client) {
        S3FileSystem s3FileSystem = new S3FileSystem(options);
        s3FileSystem.setAmazonS3Client(client);
        return s3FileSystem;
    }

    @Nullable
    static String getSSECustomerKeyMd5(S3Options options) {
        SSECustomerKey sseCostumerKey = options.getSSECustomerKey();
        if (sseCostumerKey != null) {
            return Base64.encodeAsString((byte[])DigestUtils.md5((byte[])Base64.decode((String)sseCostumerKey.getKey())));
        }
        return null;
    }

    private static class PathStyleAcccessS3ClientBuilderFactory
    extends DefaultS3ClientBuilderFactory {
        private PathStyleAcccessS3ClientBuilderFactory() {
        }

        public AmazonS3ClientBuilder createBuilder(S3Options s3Options) {
            return (AmazonS3ClientBuilder)super.createBuilder(s3Options).withPathStyleAccessEnabled(Boolean.valueOf(true));
        }
    }
}

