/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.sdk.io.aws.s3.S3ResourceId;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdTester;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class S3ResourceIdTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final List<TestCase> PATH_TEST_CASES = Arrays.asList(new TestCase("s3://bucket/", "", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "s3://bucket/"), new TestCase("s3://bucket", "", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "s3://bucket/"), new TestCase("s3://bucket", "path/to/dir", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "s3://bucket/path/to/dir/"), new TestCase("s3://bucket", "path/to/object", ResolveOptions.StandardResolveOptions.RESOLVE_FILE, "s3://bucket/path/to/object"), new TestCase("s3://bucket/path/to/dir/", "..", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "s3://bucket/path/to/"));

    @Test
    public void testResolve() {
        for (TestCase testCase : PATH_TEST_CASES) {
            S3ResourceId resourceId = S3ResourceId.fromUri((String)testCase.baseUri);
            ResourceId resolved = resourceId.resolve(testCase.relativePath, (ResolveOptions)testCase.resolveOptions);
            Assert.assertEquals((Object)testCase.expectedResult, (Object)resolved.toString());
        }
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/aa"), (Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/aa/bb/cc/"), (Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("cc", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/aa"), (Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/bb/").resolve("s3://bucket/tmp/aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my-bucket/tmp"), (Object)S3ResourceId.fromUri((String)"s3://my-bucket").resolve("tmp", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://bucket/\u8f93\u51fa \u76ee\u5f55/\u8f93\u51fa \u6587\u4ef601.txt"), (Object)S3ResourceId.fromUri((String)"s3://bucket/\u8f93\u51fa \u76ee\u5f55/").resolve("\u8f93\u51fa \u6587\u4ef601.txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
    }

    @Test
    public void testResolveInvalidInputs() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Cannot resolve a file with a directory path: [tmp/]");
        S3ResourceId.fromUri((String)"s3://my_bucket/").resolve("tmp/", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    @Test
    public void testResolveInvalidNotDirectory() {
        ResourceId tmpDir = S3ResourceId.fromUri((String)"s3://my_bucket/").resolve("tmp dir", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Expected this resource to be a directory, but was [s3://my_bucket/tmp dir]");
        tmpDir.resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    @Test
    public void testS3ResolveWithFileBase() {
        S3ResourceId resourceId = S3ResourceId.fromUri((String)"s3://bucket/path/to/file");
        this.thrown.expect(IllegalStateException.class);
        resourceId.resolve("child-path", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
    }

    @Test
    public void testResolveParentToFile() {
        S3ResourceId resourceId = S3ResourceId.fromUri((String)"s3://bucket/path/to/dir/");
        this.thrown.expect(IllegalArgumentException.class);
        resourceId.resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    @Test
    public void testGetCurrentDirectory() {
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my_bucket/tmp dir/"), (Object)S3ResourceId.fromUri((String)"s3://my_bucket/tmp dir/").getCurrentDirectory());
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my_bucket/\u8f93\u51fa \u76ee\u5f55/"), (Object)S3ResourceId.fromUri((String)"s3://my_bucket/\u8f93\u51fa \u76ee\u5f55/\u6587\u4ef601.txt").getCurrentDirectory());
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my_bucket/"), (Object)S3ResourceId.fromUri((String)"s3://my_bucket").getCurrentDirectory());
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my_bucket/"), (Object)S3ResourceId.fromUri((String)"s3://my_bucket/not-directory").getCurrentDirectory());
    }

    @Test
    public void testIsDirectory() {
        Assert.assertTrue((boolean)S3ResourceId.fromUri((String)"s3://my_bucket/tmp dir/").isDirectory());
        Assert.assertTrue((boolean)S3ResourceId.fromUri((String)"s3://my_bucket/").isDirectory());
        Assert.assertTrue((boolean)S3ResourceId.fromUri((String)"s3://my_bucket").isDirectory());
        Assert.assertFalse((boolean)S3ResourceId.fromUri((String)"s3://my_bucket/file").isDirectory());
    }

    @Test
    public void testInvalidPathNoBucket() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid S3 URI: [s3://]");
        S3ResourceId.fromUri((String)"s3://");
    }

    @Test
    public void testInvalidPathNoBucketAndSlash() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid S3 URI: [s3:///]");
        S3ResourceId.fromUri((String)"s3:///");
    }

    @Test
    public void testGetScheme() {
        Assert.assertEquals((Object)"s3", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/tmp dir/").getScheme());
        Assert.assertEquals((Object)"s3", (Object)S3ResourceId.fromUri((String)"s3://my_bucket").getScheme());
    }

    @Test
    public void testGetFilename() {
        Assert.assertNull((Object)S3ResourceId.fromUri((String)"s3://my_bucket/").getFilename());
        Assert.assertEquals((Object)"abc", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc").getFilename());
        Assert.assertEquals((Object)"abc", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc/").getFilename());
        Assert.assertEquals((Object)"def", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc/def").getFilename());
        Assert.assertEquals((Object)"def", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc/def/").getFilename());
        Assert.assertEquals((Object)"xyz.txt", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc/xyz.txt").getFilename());
    }

    @Test
    public void testParentRelationship() {
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://bucket/dir/subdir/object");
        Assert.assertEquals((Object)"bucket", (Object)path.getBucket());
        Assert.assertEquals((Object)"dir/subdir/object", (Object)path.getKey());
        path = S3ResourceId.fromUri((String)"s3://bucket/dir/subdir/");
        S3ResourceId parent = (S3ResourceId)path.resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        Assert.assertEquals((Object)"bucket", (Object)parent.getBucket());
        Assert.assertEquals((Object)"dir/", (Object)parent.getKey());
        Assert.assertNotEquals((Object)path, (Object)parent);
        Assert.assertTrue((boolean)path.getKey().startsWith(parent.getKey()));
        Assert.assertFalse((boolean)parent.getKey().startsWith(path.getKey()));
        S3ResourceId grandParent = (S3ResourceId)parent.resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        Assert.assertEquals((Object)"bucket", (Object)grandParent.getBucket());
        Assert.assertEquals((Object)"", (Object)grandParent.getKey());
    }

    @Test
    public void testBucketParsing() {
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://bucket");
        S3ResourceId path2 = S3ResourceId.fromUri((String)"s3://bucket/");
        Assert.assertEquals((Object)path, (Object)path2);
        Assert.assertEquals((Object)path.toString(), (Object)path2.toString());
    }

    @Test
    public void testS3ResourceIdToString() {
        String filename = "s3://some-bucket/some/file.txt";
        S3ResourceId path = S3ResourceId.fromUri((String)filename);
        Assert.assertEquals((Object)filename, (Object)path.toString());
        filename = "s3://some-bucket/some/";
        path = S3ResourceId.fromUri((String)filename);
        Assert.assertEquals((Object)filename, (Object)path.toString());
        filename = "s3://some-bucket/";
        path = S3ResourceId.fromUri((String)filename);
        Assert.assertEquals((Object)filename, (Object)path.toString());
    }

    @Test
    public void testEquals() {
        S3ResourceId a = S3ResourceId.fromComponents((String)"bucket", (String)"a/b/c");
        S3ResourceId b = S3ResourceId.fromComponents((String)"bucket", (String)"a/b/c");
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertEquals((Object)a, (Object)b);
        b = S3ResourceId.fromComponents((String)a.getBucket(), (String)"a/b/c/");
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)b, (Object)a);
        b = S3ResourceId.fromComponents((String)a.getBucket(), (String)"x/y/z");
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)b, (Object)a);
        b = S3ResourceId.fromComponents((String)"other-bucket", (String)a.getKey());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)b, (Object)a);
    }

    @Test
    public void testInvalidS3ResourceId() {
        this.thrown.expect(IllegalArgumentException.class);
        S3ResourceId.fromUri((String)"file://invalid/s3/path");
    }

    @Test
    public void testInvalidBucket() {
        this.thrown.expect(IllegalArgumentException.class);
        S3ResourceId.fromComponents((String)"invalid/", (String)"");
    }

    @Test
    public void testResourceIdTester() {
        S3Options options = (S3Options)PipelineOptionsFactory.create().as(S3Options.class);
        options.setAwsRegion("us-west-1");
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        ResourceIdTester.runResourceIdBattery((ResourceId)S3ResourceId.fromUri((String)"s3://bucket/foo/"));
    }

    static final class TestCase {
        final String baseUri;
        final String relativePath;
        final ResolveOptions.StandardResolveOptions resolveOptions;
        final String expectedResult;

        TestCase(String baseUri, String relativePath, ResolveOptions.StandardResolveOptions resolveOptions, String expectedResult) {
            this.baseUri = baseUri;
            this.relativePath = relativePath;
            this.resolveOptions = resolveOptions;
            this.expectedResult = expectedResult;
        }
    }
}

